% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtrackr.R
\name{slice_min.trackr_df}
\alias{slice_min.trackr_df}
\title{Slice operations}
\usage{
\method{slice_min}{trackr_df}(
  .data,
  ...,
  .messages = c("{.count.in} before", "{.count.out} after"),
  .headline = "slice data"
)
}
\arguments{
\item{.data}{A data frame, data frame extension (e.g. a tibble), or a
lazy data frame (e.g. from dbplyr or dtplyr). See \emph{Methods}, below, for
more details.}

\item{...}{For \code{slice()}: <\code{\link[dplyr:dplyr_data_masking]{data-masking}}> Integer row
values.

Provide either positive values to keep, or negative values to drop.
The values provided must be either all positive or all negative.
Indices beyond the number of rows in the input are silently ignored.

For \verb{slice_*()}, these arguments are passed on to methods.}

\item{.messages}{a set of glue specs. The glue code can use any global
variable, \{.count.in\}, \{.count.out\} for the input and output dataframes
sizes respectively and \{.excluded\} for the difference}

\item{.headline}{a glue spec. The glue code can use any global variable,
\{.count.in\}, \{.count.out\} for the input and output dataframes sizes
respectively.}
}
\value{
the sliced dataframe with the history graph updated.
}
\description{
Slice operations behave as in dplyr, except the history graph can be updated with
tracked dataframe with the before and after sizes of the dataframe.
See \code{\link[dplyr:slice]{dplyr::slice()}}, \code{\link[dplyr:slice]{dplyr::slice_head()}}, \code{\link[dplyr:slice]{dplyr::slice_tail()}},
\code{\link[dplyr:slice]{dplyr::slice_min()}}, \code{\link[dplyr:slice]{dplyr::slice_max()}}, \code{\link[dplyr:slice]{dplyr::slice_sample()}},
for more details on the underlying functions.
}
\examples{
library(dplyr)
library(dtrackr)


# Subset the data by the maximum of a given value
iris \%>\% track() \%>\% group_by(Species) \%>\%
  slice_max(prop=0.5, order_by = Sepal.Width,
            .messages="{.count.out} / {.count.in} = {prop} (with ties)",
            .headline="Widest 50\% Sepals") \%>\%
  history()


# The narrowest 25\% of the iris data set by group can be calculated in the
# slice_min() function. Recording this is a matter of tracking and
# using glue specs.
iris \%>\%
  track() \%>\%
  group_by(Species) \%>\%
  slice_min(prop=0.25, order_by = Sepal.Width,
            .messages="{.count.out} / {.count.in} (with ties)",
            .headline="narrowest {sprintf('\%1.0f',prop*100)}\% {Species}") \%>\%
  history()

}
\seealso{
dplyr::slice_min()
}
