% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtts.utils.R
\name{frequency,data.table-method}
\alias{frequency,data.table-method}
\title{Return the number of observations per interval}
\usage{
\S4method{frequency}{data.table}(
  x,
  by,
  grid_start,
  grid_end,
  tz,
  ival_start = -by,
  ival_end,
  ival_sopen = FALSE,
  ival_eopen = TRUE
)
}
\arguments{
\item{x}{the \code{data.table} time-series for which to calculate
the frequency}

\item{by}{interval specified as a \code{nanoduration} or
\code{nanoperiod}.}

\item{grid_start}{scalar \code{nanotime} defining the start of the
grid; by default the first element of \code{x} is taken.}

\item{grid_end}{scalar \code{nanotime} defining the end of the
grid; by default the last element of \code{x} is taken.}

\item{tz}{scalar of type character. Only used when the type of
\code{by} and \code{end} is \code{nanoperiod}. It defines the
time zone for the definition of the interval.}

\item{ival_start}{scalar of type \code{nanoduration} or
\code{nanoperiod}; \code{ival_start} is added to each element
of the grid and it then defines the starting point of the
interval under consideration for the alignment onto that
element. This defaults to -\code{by} and most likely does not
need to be overriden.}

\item{ival_end}{scalar of type \code{nanoduration} or
\code{nanoperiod}; \code{ival_end} is added to each element of
the grid and it then defines the ending point of the interval
under consideration for the alignment onto that element. This
defaults to 0 and most likely does not need to be overriden.}

\item{ival_sopen}{boolean scalar that indicates if the start of
the interval is open or closed. Defaults to FALSE.}

\item{ival_eopen}{boolean scalar that indicates if the end of the
interval is open or closed. Defaults to TRUE.}
}
\value{
a \code{data.table} time-series with the number of
    observations in \code{x} that fall withing the intervals
    defined by the grid interval defined by \code{by}.
}
\description{
\code{frequency} returns the number of observations in
\code{data.table} \code{x} for each interval specified by
\code{by}.
}
\examples{
\dontrun{
one_second <- as.nanoduration("00:00:01")
one_minute <- 60 * one_second
x <- data.table(index=nanotime((1:100) * one_second), 1)
setkey(x, index)
frequency(x, one_minute)
}
}
