% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtts.utils.R
\name{grid.align}
\alias{grid.align}
\alias{grid.align,data.table,nanoduration-method}
\alias{grid.align,data.table,nanoperiod-method}
\title{Align a \code{data.table} onto a \code{nanotime} vector grid}
\usage{
grid.align(x, by, ...)

\S4method{grid.align}{data.table,nanoduration}(
  x,
  by,
  func = NULL,
  grid_start = x[[1]][1] + by,
  grid_end = tail(x[[1]], 1),
  ival_start = -by,
  ival_end = as.nanoduration(0),
  ival_sopen = FALSE,
  ival_eopen = TRUE
)

\S4method{grid.align}{data.table,nanoperiod}(
  x,
  by,
  func = NULL,
  grid_start = plus(x[[1]][1], by, tz),
  grid_end = tail(x[[1]], 1),
  ival_start = -by,
  ival_end = as.nanoperiod(0),
  ival_sopen = FALSE,
  ival_eopen = TRUE,
  tz
)
}
\arguments{
\item{x}{the \code{data.table} time-series to align from}

\item{by}{interval specified as a \code{nanoduration} or
\code{nanoperiod}.}

\item{...}{further arguments passed to or from methods.}

\item{func}{a function taking one argument and which provides an
arbitrary aggregation of its argument; if \code{NULL} then a
function which takes the closest observation is used.}

\item{grid_start}{scalar \code{nanotime} defining the start of the
grid; by default the first element of \code{x} is taken.}

\item{grid_end}{scalar \code{nanotime} defining the end of the grid; by
default the last element of \code{x} is taken.}

\item{ival_start}{scalar of type \code{nanoduration} or
\code{nanoperiod}; \code{ival_start} is added to each element
of the grid and it then defines the starting point of the
interval under consideration for the alignment onto that
element.}

\item{ival_end}{scalar of type \code{nanoduration} or
\code{nanoperiod}; \code{ival_end} is added to each element of
the grid and it then defines the ending point of the interval
under consideration for the alignment onto that element.}

\item{ival_sopen}{boolean scalar that indicates if the start of
the interval is open or closed. Defaults to FALSE.}

\item{ival_eopen}{boolean scalar that indicates if the end of the
interval is open or closed. Defaults to TRUE.}

\item{tz}{scalar of type character. Only used when the type of
\code{by} and \code{end} is \code{nanoperiod}. It defines the
time zone for the definition of the interval.}
}
\value{
a \code{data.table} time-series of the same length as
    \code{y} with the aggregations computed by \code{func}
}
\description{
\code{grid.align} returns the subset of \code{data.table} \code{x}
that aligns on the grid defined by \code{by}, \code{start} and
\code{end}
}
\details{
A grid defined by the parameter \code{by}, \code{start} and
\code{end} is created. The function then does a standard alignment
of \code{x} onto this grid (see the \code{align} function)
}
\examples{
\dontrun{
one_second <- 1e9
x <- data.table(index=nanotime(cumsum(sin(seq(0.001, pi, 0.001)) * one_second)))
x <- x[, V2 := 1:nrow(x)]
setkey(x, index)
grid.align(x, as.nanoduration("00:01:00"), sum)
}
}
