% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class-dtwSat.R
\name{dtwSat-class}
\alias{dtwSat-class}
\title{dtwSat-class}
\description{
Class for Multidimensional Time-Weighted DTW alignments
}
\section{Slots }{

\describe{
 \item{\code{call}:}{An object of class \code{\link[base]{call}}, see
 \code{\link[base]{match.call}}.}
 \item{\code{alignments}:}{A named \code{\link[base]{list}} whose elements
 have length identical to the number of alignments.
 The elements are:
      \cr\code{query}: a query identification,
      \cr\code{from}: starting dates,
      \cr\code{to}: ending dates,
	     \cr\code{distance}: TWDTW distances, and
	     \cr\code{normalizedDistance}: normalized DTW distances.
       }
 \item{\code{mapping}:}{An object of class \code{\link[base]{list}} whose
 elements have the matching points for each alignment between
 the query and the template time series.
 Each element has two vectors:
      \cr\code{index1}: matching points of the query, and
      \cr\code{index2}: matching points of the template.
      }
	\item{\code{internals}:}{An object of class \code{\link[base]{list}} whose
  elements have the internal structures used by \code{\link[dtwSat]{twdtw}}.
  The elements are:
      \cr\code{timeWeight}: the time weight matrix,
      \cr\code{localMatrix}: the time local cost matrix,
      \cr\code{costMatrix}: the cumulative cost matrix,
      \cr\code{stepPattern}: the \code{\link[dtw]{stepPattern}} used for the
      computation, see package \code{\link[dtw]{dtw}},
      \cr\code{N}: query length
      \cr\code{M}: reference length
      \cr\code{query}: the query time series, and
      \cr\code{template}: the reference time series.
      }
}
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{dtwSat}}, \code{\link[dtwSat]{twdtw}},
\code{\link[dtwSat]{plotPath}}, \code{\link[dtwSat]{plotAlignment}},
\code{\link[dtw]{stepPattern}}, and \code{\link[dtw]{dtw}}.
}

