% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTimeSeries.R
\docType{methods}
\name{getTimeSeries}
\alias{getPatterns}
\alias{getPatterns,twdtwMatches-method}
\alias{getPatterns-twdtwMatches}
\alias{getTimeSeries}
\alias{getTimeSeries,twdtwMatches-method}
\alias{getTimeSeries,twdtwRaster-method}
\alias{getTimeSeries,twdtwTimeSeries-method}
\alias{getTimeSeries-twdtwMatches}
\alias{getTimeSeries-twdtwRaster}
\alias{getTimeSeries-twdtwTimeSeries}
\title{Get time series from twdtw* objects}
\usage{
\S4method{getTimeSeries}{twdtwTimeSeries}(object, labels = NULL)

\S4method{getTimeSeries}{twdtwMatches}(object, labels = NULL)

\S4method{getPatterns}{twdtwMatches}(object, labels = NULL)

\S4method{getTimeSeries}{twdtwRaster}(object, y, labels = NULL,
  proj4string = NULL, id.labels = NULL)
}
\arguments{
\item{object}{an object of class of class twdtw*.}

\item{labels}{character vector with time series labels. For signature 
\code{\link[dtwSat]{twdtwRaster}} this argument can be used to set the 
labels for each \code{sample}, or it can be combined with \code{id.labels} 
to select samples with a specific label.}

\item{y}{a \code{\link[base]{data.frame}} whose attributes are: longitude, 
latitude, the start ''from'' and the end ''to'' of the time interval 
for each sample. This can also be a \code{\link[sp]{SpatialPointsDataFrame}} 
whose attributes are the start ''from'' and the end ''to'' of the time interval.
If missing ''from'' and/or ''to'', their are set to the time range of the object
\code{object}. As additional attribute of \code{samples} can be used as labels 
for each sample. See \code{id.labels}.}

\item{proj4string}{projection string, see \code{\link[sp]{CRS-class}}. Used 
if \code{samples} is a \code{\link[base]{data.frame}}.}

\item{id.labels}{a numeric or character with an attribute of \code{samples} to 
be used as labels of the samples. Optional.}
}
\value{
An object of class \code{\link[dtwSat]{twdtwTimeSeries}}.

a list with TWDTW results or an object \code{\link[dtwSat]{twdtwTimeSeries-class}}.
}
\description{
Get time series from objects of class twdtw*.
}
\examples{
# Getting time series from objects of class twdtwTimeSeries
ts = twdtwTimeSeries(example_ts.list)
getTimeSeries(ts, 2)
# Getting time series from objects of class twdtwTimeSeries
ts = twdtwTimeSeries(example_ts.list)
patt = twdtwTimeSeries(patterns.list)
mat = twdtwApply(x=ts, y=patt)
getTimeSeries(mat, 2)
## This example creates a twdtwRaster object and extract time series from it. 

# Creating objects of class twdtwRaster with evi and ndvi time series 
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, timeline=timeline)

# Location and time range 
ts_location = data.frame(longitude = -55.96957, latitude = -12.03864, 
                         from = "2007-09-01", to = "2013-09-01")
prj_string = "+proj=longlat +datum=WGS84 +no_defs +ellps=WGS84 +towgs84=0,0,0"

## Extract time series 
ts = getTimeSeries(rts, y = ts_location, proj4string = prj_string)
 
autoplot(ts[[1]], facets = NULL) + xlab("Time") + ylab("Value")

}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtwRaster-class}}, 
\code{\link[dtwSat]{twdtwTimeSeries-class}}, and 
\code{\link[dtwSat]{twdtwMatches-class}}
}

