% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-twdtwMatches.R, R/methods.R
\docType{methods}
\name{twdtwMatches-class}
\alias{[,twdtwMatches,ANY,ANY,ANY-method}
\alias{[[,twdtwMatches,numeric,ANY-method}
\alias{as.list,twdtwMatches-method}
\alias{as.list,twdtwRaster-method}
\alias{index,twdtwMatches-method}
\alias{is.twdtwMatches}
\alias{is.twdtwMatches,ANY-method}
\alias{labels,twdtwMatches-method}
\alias{length,twdtwMatches-method}
\alias{show,twdtwMatches-method}
\alias{twdtwMatches}
\alias{twdtwMatches,ANY-method}
\alias{twdtwMatches-class}
\alias{twdtwMatches-create}
\title{class "twdtwMatches"}
\usage{
\S4method{twdtwMatches}{ANY}(timeseries = NULL, patterns = NULL,
  alignments = NULL)

\S4method{index}{twdtwMatches}(x)

\S4method{length}{twdtwMatches}(x)

\S4method{as.list}{twdtwMatches}(x)

\S4method{as.list}{twdtwRaster}(x)

\S4method{[}{twdtwMatches,ANY,ANY,ANY}(x, i, j, drop = TRUE)

\S4method{[[}{twdtwMatches,numeric,ANY}(x, i, j, drop = TRUE)

\S4method{labels}{twdtwMatches}(object)

\S4method{show}{twdtwMatches}(object)

\S4method{is.twdtwMatches}{ANY}(x)
}
\arguments{
\item{timeseries}{a \code{\link[dtwSat]{twdtwTimeSeries}} object.}

\item{patterns}{a \code{\link[dtwSat]{twdtwTimeSeries}} object.}

\item{alignments}{an object of class list with the TWDTW results with 
the same length as \code{timeseries} or a list of twdtwMatches.}

\item{x}{an object of class twdtwMatches.}

\item{i}{indices of the time series.}

\item{j}{indices of the pattern.}

\item{drop}{if TRUE returns a data.frame, if FALSE returns a list. 
Default is TRUE.}

\item{object}{an object of class twdtwMatches.}

\item{labels}{a vector with labels of the time series.}

\item{...}{objects of class twdtwMatches.}
}
\description{
Class for Time-Weighted Dynamic Time Warping results.
}
\section{Methods (by generic)}{
\itemize{
\item \code{twdtwMatches}: Create object of class twdtwMatches.

\item \code{is.twdtwMatches}: Check if the object belongs to the class twdtwMatches.
}}
\section{Slots }{

\describe{
 \item{\code{timeseries}:}{An object of class \code{\link[dtwSat]{twdtwTimeSeries-class}} with the satellite time series.}
 \item{\code{pattern}:}{An object of class \code{\link[dtwSat]{twdtwTimeSeries-class}} with the temporal patterns.}
 \item{\code{alignments}:}{A \code{\link[base]{list}} of TWDTW results with the same length as 
 the \code{timeseries}. Each element in this list has the following results for each temporal pattern 
 in \code{patterns}:
      \cr\code{from}: a vector with the starting dates of each match in the format "YYYY-MM-DD",
      \cr\code{to}: a vector with the ending dates of each match in the format "YYYY-MM-DD", 
	     \cr\code{distance}: a vector with TWDTW dissimilarity measure, and
	     \cr\code{K}: the number of matches of the pattern.
 }
	\item{This list might have additional elements:}{ if \code{keep=TRUE} in the \code{twdtwApply} call 
	the list is extended to include internal structures used during the TWDTW computation: 
      \cr\code{costMatrix}: cumulative cost matrix,
      \cr\code{directionMatrix}: directions of steps that would be taken from each element of matrix,
      \cr\code{startingMatrix}: the starting points of each element of the matrix,
      \cr\code{stepPattern}: \code{\link[dtw]{stepPattern}} used for the 
      computation, see package \code{\link[dtw]{dtw}},
      \cr\code{N}: the length of the \code{pattern}, 
      \cr\code{M}: the length of the time series \code{timeseries}, 
      \cr\code{timeWeight}: time weight matrix,
      \cr\code{localMatrix}: local cost matrix,
	     \cr\code{matching}: A list whose elements have the matching points for 
	     each match between pattern the time series, such that:
         \cr--\code{index1}: a vector with matching points of the pattern, and
         \cr--\code{index2}: a vector with matching points of the time series.
      }
}
}
\examples{
ts = twdtwTimeSeries(timeseries=example_ts.list)
patterns = twdtwTimeSeries(timeseries=patterns.list)
matches = twdtwApply(x = ts, y = patterns)
class(matches)
length(matches)
matches 
# Creating objects of class twdtwMatches 
ts  = twdtwTimeSeries(example_ts.list)
patt = twdtwTimeSeries(patterns.list)
mat = twdtwApply(ts, patt, weight.fun = logisticWeight(-0.1, 100))
mat = twdtwMatches(ts, patterns=patt, alignments=mat)
mat

}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtwApply}}, 
\code{\link[dtwSat]{twdtwTimeSeries-class}}, and 
\code{\link[dtwSat]{twdtwRaster-class}}
}

