% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twdtwXtable.R
\docType{methods}
\name{twdtwXtable}
\alias{twdtwXtable}
\alias{twdtwXtable,twdtwAssessment-method}
\alias{twdtwXtable-twdtwAssessment}
\alias{twdtwXtable,twdtwCrossValidation-method}
\alias{twdtwXtable-twdtwCrossValidation}
\title{LaTeX table from accuracy metrics}
\usage{
\S4method{twdtwXtable}{twdtwAssessment}(object, table.type = "accuracy",
  show.prop = TRUE, category.name = NULL, category.type = NULL,
  rotate.col = FALSE, time.labels = NULL, caption = NULL,
  digits = 2, show.footnote = TRUE, ...)

\S4method{twdtwXtable}{twdtwCrossValidation}(object, conf.int = 0.95,
  show.overall = TRUE, category.name = NULL, category.type = NULL,
  caption = NULL, digits = 2, show.footnote = TRUE, ...)
}
\arguments{
\item{object}{an object of class twdtwAssessment.}

\item{table.type}{Table type, 'accuracy' for User's and Producer's Accuracy, 
'errormatrix' for error matrix, and 'area' for area and uncertainty. 
Default is 'accuracy'.}

\item{show.prop}{If TRUE shows the estimated proportion of area.
Used with \code{table.type='accuracy'}. Default is TRUE.}

\item{category.name}{A character vector defining the class names. If NULL
the class names in the object \code{x} are used. Default is NULL.}

\item{category.type}{A character defining the categories type "numeric" 
or "letter", if NULL the class names are used. Default is NULL.}

\item{rotate.col}{Rotate class column names in latex table. Default is FALSE.}

\item{time.labels}{A character or numeric for the time period or NULL to 
include all classified periods. Default is NULL.}

\item{caption}{The table caption.}

\item{digits}{Number of digits to show.}

\item{show.footnote}{Show confidence interval in the footnote.}

\item{...}{Other arguments to pass to \code{\link[xtable]{print.xtable}}.}

\item{conf.int}{Specifies the confidence level (0-1).}

\item{show.overall}{If TRUE shows the overall accuracy of the cross-validation.
Default is TRUE.}
}
\description{
Creates LaTeX table from accuracy metrics
}
\examples{
\dontrun{

# Create raster time series
evi = brick(system.file("lucc_MT/data/evi.tif", package="dtwSat"))
ndvi = brick(system.file("lucc_MT/data/ndvi.tif", package="dtwSat"))
red = brick(system.file("lucc_MT/data/red.tif", package="dtwSat"))
blue = brick(system.file("lucc_MT/data/blue.tif", package="dtwSat"))
nir = brick(system.file("lucc_MT/data/nir.tif", package="dtwSat"))
mir = brick(system.file("lucc_MT/data/mir.tif", package="dtwSat"))
doy = brick(system.file("lucc_MT/data/doy.tif", package="dtwSat"))
timeline = scan(system.file("lucc_MT/data/timeline", package="dtwSat"), what="date")
rts = twdtwRaster(evi, ndvi, red, blue, nir, mir, timeline = timeline, doy = doy)

# Read field samples 
field_samples = read.csv(system.file("lucc_MT/data/samples.csv", package="dtwSat"))
proj_str = scan(system.file("lucc_MT/data/samples_projection", 
                package="dtwSat"), what = "character")

# Split samples for training (10\%) and validation (90\%) using stratified sampling 
library(caret) 
set.seed(1)
I = unlist(createDataPartition(field_samples$label, p = 0.1))
training_samples = field_samples[I,]
validation_samples = field_samples[-I,]

# Create temporal patterns 
training_ts = getTimeSeries(rts, y = training_samples, proj4string = proj_str)
temporal_patterns = createPatterns(training_ts, freq = 8, formula = y ~ s(x))

# Run TWDTW analysis for raster time series 
log_fun = weight.fun=logisticWeight(-0.1,50)
r_twdtw = twdtwApply(x=rts, y=temporal_patterns, weight.fun=log_fun, format="GTiff", 
                     overwrite=TRUE)
                     
# Classify raster based on the TWDTW analysis 
r_lucc = twdtwClassify(r_twdtw, format="GTiff", overwrite=TRUE)
plot(r_lucc)

# Assess classification 
twdtw_assess = twdtwAssess(object = r_lucc, y = validation_samples, 
                           proj4string = proj_str, conf.int=.95) 
twdtw_assess

# Create latex tables 
twdtwXtable(twdtw_assess, table.type="errormatrix", rotate.col=TRUE,
  caption="Error matrix", digits=2, comment=FALSE)
twdtwXtable(twdtw_assess, table.type="accuracy", category.type="letter", 
  caption="Accuracy metrics.")
twdtwXtable(twdtw_assess, table.type="area", category.type="letter",
  digits = 0, caption="Area and uncertainty")

}
}
\references{
\insertRef{Maus:2019}{dtwSat}
  
  \insertRef{Maus:2016}{dtwSat}
}
\seealso{
\code{\link[dtwSat]{twdtwAssess}} and  
\code{\link[dtwSat]{twdtwAssessment}}.
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
