% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/lb-keogh.R
\name{lb_keogh}
\alias{lb_keogh}
\title{Keogh's DTW lower bound}
\usage{
lb_keogh(x, y, window.size = NULL, norm = "L1")
}
\arguments{
\item{x}{A time series.}

\item{y}{A time series with the same length as \code{x}.}

\item{window.size}{Window size for envelope calculation. See details.}

\item{norm}{Pointwise distance. Either \code{L1} for Manhattan distance or \code{L2} for Euclidean.}
}
\value{
A list with: \itemize{
  \item \code{d}: The lower bound of the DTW distance.
  \item \code{upper.env}: The time series of the upper envelope.
  \item \code{lower.env}: The time series of the lower envelope.
}
}
\description{
This function calculates a lower bound (LB) on the Dynamic Time Warp (DTW) distance between two time
series. It uses a Sakoe-Chiba constraint.
}
\details{
The lower bound is defined for time series of equal length only.

The windowing constraint uses a centered window. The calculations expect a value in \code{window.size}
that represents the distance between the point considered and one of the edges of the window. Therefore,
if, for example, \code{window.size = 10}, the warping for an observation \eqn{x_i} considers the points
between \eqn{x_{i-10}} and \eqn{x_{i+10}}, resulting in \code{10*2 + 1 = 21} observations falling within
the window.
}
\examples{
# Sample data
data(uciCT)

# Lower bound distance between two series
d.lbk <- lb_keogh(CharTraj[[1]], CharTraj[[2]], window.size = 20)$d

# Corresponding true DTW distance
d.dtw <- dtw(CharTraj[[1]], CharTraj[[2]], window.type = "slantedband", window.size = 20)$distance

d.lbk <= d.dtw
}
\references{
Keogh E and Ratanamahatana CA (2005). ``Exact indexing of dynamic time warping.'' \emph{Knowledge and information systems}, \strong{7}(3),
pp. 358-386.
}

