# Generated by 02-duckplyr_df-methods.R
#' @export
relocate.duckplyr_df <- function(.data, ..., .before = NULL, .after = NULL) {
  loc <- eval_relocate(
    expr = expr(c(...)),
    data = .data,
    before = enquo(.before),
    after = enquo(.after),
    before_arg = ".before",
    after_arg = ".after"
  )

  exprs <- exprs_from_loc(.data, loc)

  # Ensure `relocate()` appears in call stack
  rel_try(
    "Can't use relational with zero-column result set." = (length(exprs) == 0),
    {
      rel <- duckdb_rel_from_df(.data)
      out <- exprs_project(rel, exprs, .data)
      return(out)
    }
  )

  # dplyr forward
  relocate <- dplyr$relocate.data.frame
  out <- relocate(.data, ..., .before = {{ .before }}, .after = {{ .after }})
  return(out)

  # dplyr implementation
  loc <- eval_relocate(
    expr = expr(c(...)),
    data = .data,
    before = enquo(.before),
    after = enquo(.after),
    before_arg = ".before",
    after_arg = ".after"
  )

  out <- dplyr_col_select(.data, loc)
  out <- set_names(out, names(loc))

  out
}

duckplyr_relocate <- function(.data, ...) {
  try_fetch(
    .data <- as_duckplyr_df(.data),
    error = function(e) {
      testthat::skip(conditionMessage(e))
    }
  )
  out <- relocate(.data, ...)
  class(out) <- setdiff(class(out), "duckplyr_df")
  out
}
