## ----setup, include = FALSE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

# Increase width for printing tibbles
old <- options(width = 220)

## ----library, message = FALSE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
library(dwctaxon)
library(dplyr)

set.seed(12345)

## ----filmy-data-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dct_filmies

## ----filmy-data-mess------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
filmies_dirty <-
  dct_filmies |>
  # Change taxonomic status of one row to 'good'
  dct_modify_row(taxonID = "54115096", taxonomicStatus = "good") |>
  # Duplicate some rows at the end
  bind_rows(tail(dct_filmies)) |>
  # Insert bad values for `acceptedNameUsageID` of 5 random rows
  rows_update(
    tibble(
      taxonID = sample(dct_filmies$taxonID, 5),
      acceptedNameUsageID = sample(letters, 5)
    ),
    by = "taxonID"
  )

filmies_dirty

## ----validate-error, error = TRUE-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dct_validate(filmies_dirty)

## ----get-dups, echo = FALSE, warning = FALSE------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dup_taxid <- dct_validate(filmies_dirty, on_fail = "summary") |>
  filter(stringr::str_detect(error, "taxonID .* duplicated value")) |>
  pull(taxonID) |>
  knitr::combine_words()

## ----validate-error-summary, error = TRUE---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dct_validate(filmies_dirty, on_fail = "summary")

## ----check-tax-id, error = TRUE-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
filmies_dirty |>
  dct_check_mapping()

## ----set-tax-status-manual------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
filmies_dirty |>
  dct_check_tax_status(
    valid_tax_status = "good, accepted, synonym",
    on_success = "logical" # Issue "TRUE" if the check passes
  )

## ----set-tax-status-default-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
# First save the current settings before making any changes
old_settings <- dct_options()

# Change valid_tax_status setting
dct_options(valid_tax_status = "good, accepted, synonym")

## ----set-tax-status-manual-2----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
filmies_dirty |>
  dct_check_tax_status(on_success = "logical")

## ----reset-defaults-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dct_options(reset = TRUE)

## ----set-tax-status-manual-3, error = TRUE--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
filmies_dirty |>
  dct_check_tax_status(on_success = "logical")

## ----dct-options-show-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dct_options()

## ----dct-options-show-single----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
dct_options()$valid_tax_status

## ----dct-options-restore--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
do.call(dct_options, old_settings)

## ---- include = FALSE---------------------------------------------------------
# Reset options
options(old)

