% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sieve_win}
\alias{sieve_win}
\title{Test Criteria for Model Selection within Search Area}
\format{
A list containing the parameters used for test criteria in model 
selection in \code{ddArray} objects. The \code{sieve_win} values are used 
when either \code{sieve = "win"} or \code{extent = "win"} in arg list of
\code{\link{modelFilter}}. The sieve parameters are:
\describe{
 \item{\code{$aic = 10}}{the cutoff for DeltaAIC scores; models with higher 
	scores are removed from further consideration.}
 \item{\code{$hin = T}}{a boolean to indicate whether or not to use high 
	leverage points as a criterion for model selection.}
 \item{\code{$rtail}}{Appropriate only for extrapolating beyond the search
	radius. Automatically disabled via\code{rtail = sieve_default$rtail * 0}.}
 \item{\code{ltail}}{Appropriate only for extrapolating beyond the search
	radius. Automaticall disabled via \code{ltail = sieve_default$ltail * 0 + 1}}
}
}
\usage{
sieve_win
}
\description{
Test Criteria for Model Selection within Search Area
}
\keyword{datasets}
