/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import org.jvnet.lafwidget.LafWidget;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.lafwidget.utils.FadeStateListener;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.lafwidget.utils.RenderingUtils;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.RolloverButtonListener;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class SubstanceCheckBoxUI
extends SubstanceRadioButtonUI {
    protected Set lafWidgets;
    private static final String propertyPrefix = "CheckBox.";
    protected FadeStateListener substanceFadeStateListener;
    protected PropertyChangeListener substancePropertyListener;
    private static Map<String, Icon> icons = new HashMap<String, Icon>();
    private static final int DIMENSION = 16;

    public void __org__jvnet__substance__SubstanceCheckBoxUI__installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
    }

    public void installDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__installDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceCheckBoxUI__uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
    }

    public void uninstallDefaults(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__uninstallDefaults(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallDefaults();
        }
    }

    public void __org__jvnet__substance__SubstanceCheckBoxUI__update(Graphics graphics, JComponent jComponent) {
        super.update(graphics, jComponent);
    }

    public void update(Graphics graphics, JComponent jComponent) {
        Object object;
        Graphics2D graphics2D = (Graphics2D)graphics;
        Composite composite = graphics2D.getComposite();
        float f = 1.0f;
        if (composite instanceof AlphaComposite && ((AlphaComposite)(object = (AlphaComposite)composite)).getRule() == 3) {
            f = ((AlphaComposite)object).getAlpha();
        }
        graphics2D.setComposite(TransitionLayout.getAlphaComposite(jComponent, f));
        object = RenderingUtils.installDesktopHints(graphics2D);
        this.__org__jvnet__substance__SubstanceCheckBoxUI__update(graphics2D, jComponent);
        graphics2D.setComposite(composite);
        if (object != null) {
            graphics2D.addRenderingHints((Map<?, ?>)object);
        }
    }

    public void __org__jvnet__substance__SubstanceCheckBoxUI__uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
    }

    public void uninstallUI(JComponent jComponent) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__uninstallUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallUI();
        }
    }

    public void uninstallListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__uninstallListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.uninstallListeners();
        }
    }

    public void __org__jvnet__substance__SubstanceCheckBoxUI__installUI(JComponent jComponent) {
        super.installUI(jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.lafWidgets = LafWidgetRepository.getRepository().getMatchingWidgets(jComponent);
        this.__org__jvnet__substance__SubstanceCheckBoxUI__installUI(jComponent);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installUI();
        }
    }

    public void installListeners(AbstractButton abstractButton) {
        this.__org__jvnet__substance__SubstanceCheckBoxUI__installListeners(abstractButton);
        for (LafWidget lafWidget : this.lafWidgets) {
            lafWidget.installListeners();
        }
    }

    public static ComponentUI createUI(JComponent b) {
        return new SubstanceCheckBoxUI((JToggleButton)b);
    }

    private SubstanceCheckBoxUI(JToggleButton button) {
        super(button);
        button.setRolloverEnabled(true);
    }

    protected String getPropertyPrefix() {
        return propertyPrefix;
    }

    protected void __org__jvnet__substance__SubstanceCheckBoxUI__installListeners(final AbstractButton b) {
        super.installListeners(b);
        this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
        this.substanceFadeStateListener.registerListeners();
        this.substancePropertyListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("model".equals(evt.getPropertyName())) {
                    if (SubstanceCheckBoxUI.this.substanceFadeStateListener != null) {
                        SubstanceCheckBoxUI.this.substanceFadeStateListener.unregisterListeners();
                    }
                    SubstanceCheckBoxUI.this.substanceFadeStateListener = new FadeStateListener(b, b.getModel(), null);
                    SubstanceCheckBoxUI.this.substanceFadeStateListener.registerListeners();
                }
            }
        };
        b.addPropertyChangeListener(this.substancePropertyListener);
    }

    protected void __org__jvnet__substance__SubstanceCheckBoxUI__uninstallListeners(AbstractButton b) {
        this.substanceFadeStateListener.unregisterListeners();
        this.substanceFadeStateListener = null;
        b.removePropertyChangeListener(this.substancePropertyListener);
        this.substancePropertyListener = null;
        super.uninstallListeners(b);
    }

    public static synchronized void reset() {
        icons.clear();
    }

    private static synchronized Icon getIcon(JToggleButton button, ComponentState state) {
        SubstanceTheme theme;
        float visibility;
        FadeTracker fadeTracker = FadeTracker.getInstance();
        float f = visibility = state.isSelected() ? 10.0f : 0.0f;
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.SELECTION)) {
            visibility = fadeTracker.getFade10(button, FadeTracker.FadeKind.SELECTION);
        }
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
            SubstanceTheme defaultTheme = SubstanceCoreUtilities.getDefaultTheme(button, true);
            SubstanceTheme theme2 = theme = SubstanceCoreUtilities.getActiveTheme(button, true);
            float cyclePos = 0.0f;
            if (!state.isSelected() && state.isEnabled()) {
                if (state == ComponentState.DEFAULT) {
                    theme2 = defaultTheme;
                    cyclePos = 10.0f - fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                } else {
                    theme2 = theme;
                    theme = defaultTheme;
                    cyclePos = fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                }
                String key = state.name() + ":" + theme.getDisplayName() + ":" + theme2.getDisplayName() + ":" + cyclePos + ":" + visibility;
                Icon result = icons.get(key);
                if (result != null) {
                    return result;
                }
                result = new ImageIcon(SubstanceImageCreator.getCheckBox(button, 16, state, theme, theme2, cyclePos, visibility / 10.0f));
                icons.put(key, result);
                return result;
            }
        }
        ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
        theme = SubstanceCoreUtilities.getComponentTheme(button, kind);
        int cyclePos = state.getCycleCount();
        String key = state.name() + ":" + theme.getDisplayName() + ":" + theme.getDisplayName() + ":" + cyclePos + ":" + visibility;
        Icon result = icons.get(key);
        if (result != null) {
            return result;
        }
        result = new ImageIcon(SubstanceImageCreator.getCheckBox(button, 16, state, theme, theme, cyclePos, visibility / 10.0f));
        icons.put(key, result);
        return result;
    }

    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new RolloverButtonListener(b);
    }

    public Icon getDefaultIcon() {
        ButtonModel model = this.button.getModel();
        return SubstanceCheckBoxUI.getIcon(this.button, ComponentState.getState(model, this.button));
    }

    public static String getMemoryUsage() {
        StringBuffer sb = new StringBuffer();
        sb.append("SubstanceCheckBox: \n");
        sb.append("\t" + icons.size() + " icons");
        return sb.toString();
    }
}

