/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance;

import contrib.com.jgoodies.looks.LookUtils;
import contrib.com.jgoodies.looks.common.ShadowPopupFactory;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import org.jvnet.lafplugin.ComponentPluginManager;
import org.jvnet.lafplugin.PluginManager;
import org.jvnet.lafwidget.LafWidgetRepository;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.lafwidget.utils.TrackableThread;
import org.jvnet.substance.SubstanceCheckBoxUI;
import org.jvnet.substance.SubstanceComboBoxUI;
import org.jvnet.substance.SubstanceMenuBarUI;
import org.jvnet.substance.SubstanceProgressBarUI;
import org.jvnet.substance.SubstanceRadioButtonUI;
import org.jvnet.substance.SubstanceRootPaneUI;
import org.jvnet.substance.SubstanceScrollBarUI;
import org.jvnet.substance.SubstanceTabbedPaneUI;
import org.jvnet.substance.SubstanceWidgetSupport;
import org.jvnet.substance.TabCloseListener;
import org.jvnet.substance.button.ButtonShaperChangeListener;
import org.jvnet.substance.button.ButtonShaperInfo;
import org.jvnet.substance.button.StandardButtonShaper;
import org.jvnet.substance.button.SubstanceButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.DefaultControlBackgroundComposite;
import org.jvnet.substance.painter.GradientPainterChangeListener;
import org.jvnet.substance.painter.GradientPainterInfo;
import org.jvnet.substance.painter.StandardGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.plugin.SubstanceButtonShaperPlugin;
import org.jvnet.substance.plugin.SubstanceGradientPainterPlugin;
import org.jvnet.substance.plugin.SubstanceSkinPlugin;
import org.jvnet.substance.plugin.SubstanceThemePlugin;
import org.jvnet.substance.plugin.SubstanceTitlePainterPlugin;
import org.jvnet.substance.plugin.SubstanceWatermarkPlugin;
import org.jvnet.substance.skin.SkinChangeListener;
import org.jvnet.substance.skin.SkinInfo;
import org.jvnet.substance.skin.SubstanceSkin;
import org.jvnet.substance.tabbed.BaseTabCloseListener;
import org.jvnet.substance.theme.MixedThemeInfo;
import org.jvnet.substance.theme.SubstanceAquaTheme;
import org.jvnet.substance.theme.SubstanceMixTheme;
import org.jvnet.substance.theme.SubstanceTheme;
import org.jvnet.substance.theme.ThemeChangeListener;
import org.jvnet.substance.theme.ThemeInfo;
import org.jvnet.substance.title.ClassicTitlePainter;
import org.jvnet.substance.title.Glass3DTitlePainter;
import org.jvnet.substance.title.SubstanceTitlePainter;
import org.jvnet.substance.title.TitleButtonInfo;
import org.jvnet.substance.title.TitleButtonManager;
import org.jvnet.substance.title.TitlePainterChangeListener;
import org.jvnet.substance.title.TitlePainterInfo;
import org.jvnet.substance.utils.ButtonBackgroundDelegate;
import org.jvnet.substance.utils.LocaleChangeListener;
import org.jvnet.substance.utils.MemoryAnalyzer;
import org.jvnet.substance.utils.PulseTracker;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceTitlePane;
import org.jvnet.substance.utils.TabCloseListenerManager;
import org.jvnet.substance.utils.icon.SubstanceIconFactory;
import org.jvnet.substance.utils.params.JvmFlagsParamReader;
import org.jvnet.substance.utils.params.ParamReader;
import org.jvnet.substance.utils.params.PropertiesFileParamReader;
import org.jvnet.substance.watermark.SubstanceImageWatermark;
import org.jvnet.substance.watermark.SubstanceStripeWatermark;
import org.jvnet.substance.watermark.SubstanceWatermark;
import org.jvnet.substance.watermark.WatermarkChangeListener;
import org.jvnet.substance.watermark.WatermarkInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstanceLookAndFeel
extends BasicLookAndFeel {
    public static final String PLUGIN_XML = "META-INF/substance-plugin.xml";
    protected static ComponentPluginManager componentPlugins;
    protected static PluginManager themePlugins;
    protected static PluginManager skinPlugins;
    protected static PluginManager watermarkPlugins;
    protected static PluginManager shaperPlugins;
    protected static PluginManager painterPlugins;
    protected static PluginManager titlePainterPlugins;
    protected static Set<SkinChangeListener> skinChangeListeners;
    protected static Set<ThemeChangeListener> themeChangeListeners;
    protected static Set<WatermarkChangeListener> watermarkChangeListeners;
    protected static Set<ButtonShaperChangeListener> buttonShaperChangeListeners;
    protected static Set<GradientPainterChangeListener> gradientPainterChangeListeners;
    protected static Set<TitlePainterChangeListener> titlePainterChangeListeners;
    protected static Set<LocaleChangeListener> localeChangeListeners;
    protected static Set<String> ignoreAnimationsSet;
    protected static Map<String, SubstanceMixTheme> mixedThemes;
    protected static Map<Class<?>, ControlBackgroundComposite> backgroundComposites;
    protected static boolean toShowExtraElements;
    protected static boolean toUseConstantThemesOnDialogs;
    protected static boolean toEnableInvertedThemes;
    protected static boolean toEnableNegatedThemes;
    protected static boolean toBleedWatermark;
    protected static boolean isDebugUiMode;
    protected static int fontSizeExtra;
    protected static int baseFontSize;
    protected static boolean isFontSizeExtraSet;
    protected static boolean isFontBold;
    public static final FadeTracker.FadeKind BORDER_ANIMATION_KIND;
    public static final String DEBUG_UI_MODE = "substancelaf.debugUiMode";
    public static final String THEME_PROPERTY = "substancelaf.theme";
    @Deprecated
    public static final String BUTTON_THEME_PROPERTY = "substancelaf.theme";
    public static final String WATERMARK_PROPERTY = "substancelaf.watermark";
    public static final String WATERMARK_IMAGE_PROPERTY = "substancelaf.watermark.image";
    public static final String WATERMARK_TO_BLEED = "substancelaf.watermark.tobleed";
    public static final String WATERMARK_IGNORE = "substancelaf.watermark.toignore";
    public static final String WATERMARK_IMAGE_KIND = "substancelaf.watermark.image.kind";
    public static final String WATERMARK_IMAGE_OPACITY = "substancelaf.watermark.image.opacity";
    public static final String BUTTON_NO_MIN_SIZE_PROPERTY = "substancelaf.buttonnominsize";
    public static final String PAINT_ACTIVE_PROPERTY = "substancelaf.paintactive";
    @Deprecated
    public static final String BUTTON_PAINT_ACTIVE_PROPERTY = "substancelaf.paintactive";
    public static final String BUTTON_PAINT_NEVER_PROPERTY = "substancelaf.buttonpaintnever";
    public static final String BUTTON_SIDE_PROPERTY = "substancelaf.buttonside";
    public static final String BUTTON_OPEN_SIDE_PROPERTY = "substancelaf.buttonopenSide";
    public static final String BUTTON_SHAPER_PROPERTY = "substancelaf.buttonShaper";
    public static final String CORNER_RADIUS = "substancelaf.cornerRadius";
    public static final String FLAT_PROPERTY = "substancelaf.componentFlat";
    public static final String OVERLAY_PROPERTY = "substancelaf.overlay";
    public static final String SCROLLBAR_GRIP_PAINTER = "substancelaf.scrollBarGripPainter";
    public static final String GRADIENT_PAINTER_PROPERTY = "substancelaf.gradientPainter";
    public static final String TITLE_PAINTER_PROPERTY = "substancelaf.titlePainter";
    public static final String HEAP_STATUS_PANEL = "substancelaf.heapStatusPanel";
    public static final String WINDOW_MODIFIED = "windowModified";
    public static final String BACKGROUND_COMPOSITE = "substancelaf.backgroundComposite";
    public static final String TABBED_PANE_TAB_ANIMATION_KIND = "substancelaf.tabbedpanetabAnimationKind";
    public static final String TABBED_PANE_CLOSE_BUTTONS_PROPERTY = "substancelaf.tabbedpanehasclosebuttons";
    public static final String TABBED_PANE_VERTICAL_ORIENTATION = "substancelaf.tabbedpaneverticalOrientation";
    public static final String TABBED_PANE_VERTICAL_ORIENTATION_ROTATE_ICONS = "substancelaf.tabbedpaneverticalOrientationRotateIcons";
    public static final String TABBED_PANE_CLOSE_BUTTONS_SIZE = "substancelaf.tabbedpaneclosebuttonssize";
    public static final String TABBED_PANE_CLOSE_BUTTONS_MODIFIED_ANIMATION = "substancelaf.tabbedpaneclosebuttonsmodifiedanimation";
    public static final String TABBED_PANE_CLOSE_CALLBACK = "substancelaf.tabbedpanecloseCallback";
    public static final String TABBED_PANE_TEXT_ALIGNMENT_KIND = "substancelaf.tabbedpanetextAlignmentKind";
    public static final String COMBO_BOX_POPUP_FLYOUT_ORIENTATION = "substancelaf.comboboxpopupFlyoutOrientation";
    public static final String SCROLL_PANE_BUTTONS_POLICY = "substancelaf.scrollPaneButtonsPolicy";
    public static final String NO_EXTRA_ELEMENTS = "substancelaf.noExtraElements";
    public static final String MENU_GUTTER_FILL_KIND = "substancelaf.menuGutterFillKind";
    public static final String FOCUS_KIND = "substancelaf.focusKind";
    public static final String COMBO_POPUP_PROTOTYPE = "substancelaf.comboPopupPrototype";
    public static final String TRACE_FILE = "substancelaf.traceFile";
    public static final String FONT_EXTRA_SIZE = "substancelaf.fontSizeExtra";
    public static final String CONFIG_FILE = "substancelaf.configFile";
    public static final String ENABLE_INVERTED_THEMES = "substancelaf.enableInvertedThemes";
    public static final String ENABLE_NEGATED_THEMES = "substancelaf.enableNegatedThemes";
    public static final String PASSWORD_ECHO_PER_CHAR = "substancelaf.passwordEchoPerChar";
    public static final String TOOLBAR_BUTTON_FLAT = "substancelaf.toolbarButtonFlat";
    public static final String PERMANENTLY_PINNED = "substancelaf.permanentlyPinned";
    public static final String CAN_BE_PINNED = "substancelaf.canBePinned";
    protected static ParamReader paramReader;
    private static ResourceBundle LABEL_BUNDLE;
    private static ClassLoader labelBundleClassLoader;
    private static SubstanceTheme currentTheme;
    private static SubstanceWatermark currentWatermark;
    private static SubstanceButtonShaper currentButtonShaper;
    private static SubstanceGradientPainter currentGradientPainter;
    private static SubstanceTitlePainter currentTitlePainter;

    @Override
    protected void initClassDefaults(UIDefaults uIDefaults) {
        this.__org__jvnet__substance__SubstanceLookAndFeel__initClassDefaults(uIDefaults);
        uIDefaults.put("LabelUI", "org.jvnet.substance.__Forwarding__LabelUI");
        uIDefaults.put("ToolBarSeparatorUI", "org.jvnet.substance.__Forwarding__ToolBarSeparatorUI");
        uIDefaults.put("ToolTipUI", "org.jvnet.substance.__Forwarding__ToolTipUI");
        uIDefaults.put("ViewportUI", "org.jvnet.substance.__Forwarding__ViewportUI");
    }

    public static synchronized ResourceBundle getLabelBundle() {
        if (LABEL_BUNDLE == null) {
            LABEL_BUNDLE = labelBundleClassLoader == null ? ResourceBundle.getBundle("org.jvnet.substance.resources.Labels", Locale.getDefault()) : ResourceBundle.getBundle("org.jvnet.substance.resources.Labels", Locale.getDefault(), labelBundleClassLoader);
            for (LocaleChangeListener lcl : localeChangeListeners) {
                lcl.localeChanged();
            }
        }
        return LABEL_BUNDLE;
    }

    public static synchronized void resetLabelBundle() {
        LABEL_BUNDLE = null;
        LafWidgetRepository.resetLabelBundle();
    }

    public SubstanceLookAndFeel() {
        componentPlugins = new ComponentPluginManager(PLUGIN_XML);
        themePlugins = new PluginManager(PLUGIN_XML, "laf-plugin", "theme-plugin-class");
        skinPlugins = new PluginManager(PLUGIN_XML, "laf-plugin", "skin-plugin-class");
        watermarkPlugins = new PluginManager(PLUGIN_XML, "laf-plugin", "watermark-plugin-class");
        shaperPlugins = new PluginManager(PLUGIN_XML, "laf-plugin", "button-shaper-plugin-class");
        painterPlugins = new PluginManager(PLUGIN_XML, "laf-plugin", "gradient-painter-plugin-class");
        titlePainterPlugins = new PluginManager(PLUGIN_XML, "laf-plugin", "title-painter-plugin-class");
        JvmFlagsParamReader bootstrapReader = new JvmFlagsParamReader();
        String configFileName = bootstrapReader.getConfigFileName();
        paramReader = bootstrapReader;
        if (configFileName != null) {
            paramReader = new PropertiesFileParamReader(configFileName);
        }
    }

    public static ColorScheme getColorScheme() {
        return SubstanceLookAndFeel.getActiveColorScheme();
    }

    public static SubstanceTheme getTheme() {
        if (currentTheme == null) {
            return new SubstanceAquaTheme();
        }
        return currentTheme;
    }

    public static ColorScheme getActiveColorScheme() {
        return SubstanceCoreUtilities.getActiveScheme(null);
    }

    public static ColorScheme getDefaultColorScheme() {
        return SubstanceCoreUtilities.getDefaultScheme(null);
    }

    public static ColorScheme getDisabledColorScheme() {
        return SubstanceCoreUtilities.getDisabledScheme(null);
    }

    public static ColorScheme getMetallicColorScheme() {
        return SubstanceLookAndFeel.getDefaultColorScheme();
    }

    public static ColorScheme getGrayColorScheme() {
        return SubstanceLookAndFeel.getDisabledColorScheme();
    }

    public static boolean setCurrentTheme(String themeClassName) {
        return SubstanceLookAndFeel.setCurrentTheme(themeClassName, true);
    }

    private static boolean setCurrentTheme(String themeClassName, boolean toUpdateUiTable) {
        try {
            Class<?> themeClass = Class.forName(themeClassName);
            if (themeClass == null) {
                return false;
            }
            Object obj = themeClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceTheme)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentTheme((SubstanceTheme)obj, toUpdateUiTable);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentTheme(ThemeInfo themeInfo) {
        return SubstanceLookAndFeel.setCurrentTheme(themeInfo, true);
    }

    private static boolean setCurrentTheme(ThemeInfo themeInfo, boolean toUpdateUiTable) {
        try {
            SubstanceTheme theme = SubstanceTheme.createInstance(themeInfo);
            if (theme == null) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentTheme(theme, toUpdateUiTable);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentTheme(SubstanceTheme theme) {
        return SubstanceLookAndFeel.setCurrentTheme(theme, true);
    }

    private static boolean setCurrentTheme(SubstanceTheme theme, boolean toUpdateUiTable) {
        UIDefaults defaults;
        currentTheme = theme;
        if (toUpdateUiTable && (defaults = UIManager.getLookAndFeelDefaults()) != null) {
            currentTheme.addCustomEntriesToTable(UIManager.getLookAndFeelDefaults());
            componentPlugins.processAllDefaultsEntries(UIManager.getLookAndFeelDefaults(), currentTheme);
        }
        SubstanceIconFactory.reset();
        ButtonBackgroundDelegate.reset();
        SubstanceCheckBoxUI.reset();
        SubstanceProgressBarUI.reset();
        SubstanceRadioButtonUI.reset();
        SubstanceScrollBarUI.reset();
        SubstanceTabbedPaneUI.reset();
        SubstanceComboBoxUI.reset();
        SubstanceScrollBarUI.reset();
        ClassicTitlePainter.reset();
        if (currentWatermark != null && currentWatermark.isDependingOnTheme()) {
            currentWatermark.updateWatermarkImage();
        }
        for (ThemeChangeListener themeChangeListener : themeChangeListeners) {
            themeChangeListener.themeChanged();
        }
        return true;
    }

    public static String getCurrentThemeName() {
        if (SubstanceLookAndFeel.getTheme() == null) {
            return null;
        }
        return SubstanceLookAndFeel.getTheme().getDisplayName();
    }

    @Deprecated
    public static Map<String, String> enumerateThemes() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Object themePlugin : themePlugins.getAvailablePlugins(true)) {
            for (ThemeInfo themeInfo : ((SubstanceThemePlugin)themePlugin).getThemes()) {
                result.put(themeInfo.getDisplayName(), themeInfo.getClassName());
            }
        }
        return result;
    }

    public static Map<String, ThemeInfo> getAllThemes() {
        TreeMap<String, ThemeInfo> result = new TreeMap<String, ThemeInfo>();
        for (Object themePlugin : themePlugins.getAvailablePlugins(true)) {
            for (ThemeInfo themeInfo : ((SubstanceThemePlugin)themePlugin).getThemes()) {
                result.put(themeInfo.getDisplayName(), themeInfo);
                if (SubstanceLookAndFeel.toEnableInvertedThemes() && (themeInfo.getThemeKind() == SubstanceTheme.ThemeKind.BRIGHT || themeInfo.getThemeKind() == SubstanceTheme.ThemeKind.COLD)) {
                    ThemeInfo invertedInfo = new ThemeInfo("Inverted " + themeInfo.getDisplayName(), themeInfo.getClassName(), SubstanceTheme.ThemeKind.INVERTED);
                    result.put(invertedInfo.getDisplayName(), invertedInfo);
                }
                if (!SubstanceLookAndFeel.toEnableNegatedThemes() || themeInfo.getThemeKind() != SubstanceTheme.ThemeKind.BRIGHT && themeInfo.getThemeKind() != SubstanceTheme.ThemeKind.COLD) continue;
                ThemeInfo negatedInfo = new ThemeInfo("Negated " + themeInfo.getDisplayName(), themeInfo.getClassName(), SubstanceTheme.ThemeKind.NEGATED);
                result.put(negatedInfo.getDisplayName(), negatedInfo);
            }
        }
        for (SubstanceMixTheme mixedTheme : mixedThemes.values()) {
            SubstanceTheme[] origThemes = mixedTheme.getOriginalThemes();
            String[] origThemeClassNames = new String[origThemes.length];
            for (int i = 0; i < origThemes.length; ++i) {
                origThemeClassNames[i] = origThemes[i].getClass().getName();
            }
            MixedThemeInfo mixedInfo = new MixedThemeInfo(mixedTheme.getDisplayName(), origThemeClassNames);
            result.put(mixedInfo.getDisplayName(), mixedInfo);
        }
        return result;
    }

    public static String getCurrentWatermarkName() {
        if (currentWatermark == null) {
            return null;
        }
        return currentWatermark.getDisplayName();
    }

    @Deprecated
    public static Map<String, String> enumerateWatermarks() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Object watermarkPlugin : watermarkPlugins.getAvailablePlugins(true)) {
            for (WatermarkInfo watermarkInfo : ((SubstanceWatermarkPlugin)watermarkPlugin).getWatermarks()) {
                result.put(watermarkInfo.getDisplayName(), watermarkInfo.getClassName());
            }
        }
        return result;
    }

    public static Map<String, WatermarkInfo> getAllWatermarks() {
        TreeMap<String, WatermarkInfo> result = new TreeMap<String, WatermarkInfo>();
        for (Object watermarkPlugin : watermarkPlugins.getAvailablePlugins(true)) {
            for (WatermarkInfo watermarkInfo : ((SubstanceWatermarkPlugin)watermarkPlugin).getWatermarks()) {
                result.put(watermarkInfo.getDisplayName(), watermarkInfo);
            }
        }
        return result;
    }

    public static SubstanceWatermark getCurrentWatermark() {
        return currentWatermark;
    }

    public static boolean setCurrentWatermark(String watermarkClassName) {
        try {
            Class<?> watermarkClass = Class.forName(watermarkClassName);
            if (watermarkClass == null) {
                return false;
            }
            Object obj = null;
            Constructor<?> paramCtr = null;
            try {
                paramCtr = watermarkClass.getConstructor(ParamReader.class);
            }
            catch (NoSuchMethodException nsme) {
                paramCtr = null;
            }
            obj = paramCtr != null ? paramCtr.newInstance(new Object[]{null}) : watermarkClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceWatermark)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentWatermark(obj);
        }
        catch (Exception exc) {
            return false;
        }
    }

    private static boolean setCurrentWatermark(String watermarkClassName, ParamReader paramReader) {
        try {
            Class<?> watermarkClass = Class.forName(watermarkClassName);
            if (watermarkClass == null) {
                return false;
            }
            Object obj = null;
            Constructor<?> paramCtr = null;
            try {
                paramCtr = watermarkClass.getConstructor(ParamReader.class);
            }
            catch (NoSuchMethodException nsme) {
                paramCtr = null;
            }
            obj = paramCtr != null ? paramCtr.newInstance(paramReader) : watermarkClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceWatermark)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentWatermark(obj);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentWatermark(SubstanceWatermark currentWatermark) {
        if (SubstanceLookAndFeel.currentWatermark != null) {
            SubstanceLookAndFeel.currentWatermark.dispose();
        }
        SubstanceLookAndFeel.currentWatermark = currentWatermark;
        boolean status = currentWatermark.updateWatermarkImage();
        if (status) {
            for (WatermarkChangeListener watermarkChangeListener : watermarkChangeListeners) {
                watermarkChangeListener.watermarkChanged();
            }
        }
        return status;
    }

    public static String getCurrentButtonShaperName() {
        if (currentButtonShaper == null) {
            return null;
        }
        return currentButtonShaper.getDisplayName();
    }

    public static Map<String, ButtonShaperInfo> getAllButtonShapers() {
        TreeMap<String, ButtonShaperInfo> result = new TreeMap<String, ButtonShaperInfo>();
        for (Object buttonShaperPlugin : shaperPlugins.getAvailablePlugins(true)) {
            for (ButtonShaperInfo buttonShaperInfo : ((SubstanceButtonShaperPlugin)buttonShaperPlugin).getButtonShapers()) {
                result.put(buttonShaperInfo.getDisplayName(), buttonShaperInfo);
            }
        }
        return result;
    }

    public static SubstanceButtonShaper getCurrentButtonShaper() {
        return currentButtonShaper;
    }

    public static boolean setCurrentButtonShaper(String buttonShaperClassName) {
        return SubstanceLookAndFeel.setCurrentButtonShaper(buttonShaperClassName, true);
    }

    private static boolean setCurrentButtonShaper(String buttonShaperClassName, boolean toEnsureAccess) {
        try {
            Class<?> buttonShaperClass = Class.forName(buttonShaperClassName);
            if (buttonShaperClass == null) {
                return false;
            }
            Object obj = buttonShaperClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceButtonShaper)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentButtonShaper((SubstanceButtonShaper)obj);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentButtonShaper(SubstanceButtonShaper currentButtonShaper) {
        return SubstanceLookAndFeel.setCurrentButtonShaper(currentButtonShaper, true);
    }

    private static boolean setCurrentButtonShaper(SubstanceButtonShaper currentButtonShaper, boolean toReset) {
        SubstanceLookAndFeel.currentButtonShaper = currentButtonShaper;
        if (toReset) {
            ButtonBackgroundDelegate.reset();
            SubstanceCheckBoxUI.reset();
            SubstanceRadioButtonUI.reset();
        }
        for (ButtonShaperChangeListener buttonShaperChangeListener : buttonShaperChangeListeners) {
            buttonShaperChangeListener.buttonShaperChanged();
        }
        return true;
    }

    public static String getCurrentGradientPainterName() {
        if (currentGradientPainter == null) {
            return null;
        }
        return currentGradientPainter.getDisplayName();
    }

    public static Map<String, GradientPainterInfo> getAllGradientPainters() {
        TreeMap<String, GradientPainterInfo> result = new TreeMap<String, GradientPainterInfo>();
        for (Object gradientPainterPlugin : painterPlugins.getAvailablePlugins(true)) {
            for (GradientPainterInfo gradientPainterInfo : ((SubstanceGradientPainterPlugin)gradientPainterPlugin).getGradientPainters()) {
                result.put(gradientPainterInfo.getDisplayName(), gradientPainterInfo);
            }
        }
        return result;
    }

    public static SubstanceGradientPainter getCurrentGradientPainter() {
        return currentGradientPainter;
    }

    public static boolean setCurrentGradientPainter(String gradientPainterClassName) {
        try {
            Class<?> gradientPainterClass = Class.forName(gradientPainterClassName);
            if (gradientPainterClass == null) {
                return false;
            }
            Object obj = gradientPainterClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceGradientPainter)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentGradientPainter((SubstanceGradientPainter)obj, true);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentGradientPainter(SubstanceGradientPainter currentGradientPainter) {
        return SubstanceLookAndFeel.setCurrentGradientPainter(currentGradientPainter, true);
    }

    private static boolean setCurrentGradientPainter(SubstanceGradientPainter currentGradientPainter, boolean toReset) {
        SubstanceLookAndFeel.currentGradientPainter = currentGradientPainter;
        if (toReset) {
            ButtonBackgroundDelegate.reset();
            SubstanceCheckBoxUI.reset();
            SubstanceRadioButtonUI.reset();
        }
        for (GradientPainterChangeListener gradientPainterChangeListener : gradientPainterChangeListeners) {
            gradientPainterChangeListener.gradientPainterChanged();
        }
        return true;
    }

    public static String getCurrentTitlePainterName() {
        if (currentTitlePainter == null) {
            return null;
        }
        return currentTitlePainter.getDisplayName();
    }

    public static Map<String, TitlePainterInfo> getAllTitlePainters() {
        TreeMap<String, TitlePainterInfo> result = new TreeMap<String, TitlePainterInfo>();
        for (Object titlePainterPlugin : titlePainterPlugins.getAvailablePlugins(true)) {
            for (TitlePainterInfo titlePainterInfo : ((SubstanceTitlePainterPlugin)titlePainterPlugin).getTitlePainters()) {
                result.put(titlePainterInfo.getDisplayName(), titlePainterInfo);
            }
        }
        return result;
    }

    public static SubstanceTitlePainter getCurrentTitlePainter() {
        return currentTitlePainter;
    }

    public static boolean setCurrentTitlePainter(String titlePainterClassName) {
        try {
            Class<?> titlePainterClass = Class.forName(titlePainterClassName);
            if (titlePainterClass == null) {
                return false;
            }
            Object obj = titlePainterClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceTitlePainter)) {
                return false;
            }
            return SubstanceLookAndFeel.setCurrentTitlePainter((SubstanceTitlePainter)obj, true);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static boolean setCurrentTitlePainter(SubstanceTitlePainter currentTitlePainter) {
        return SubstanceLookAndFeel.setCurrentTitlePainter(currentTitlePainter, true);
    }

    private static boolean setCurrentTitlePainter(SubstanceTitlePainter currentTitlePainter, boolean toReset) {
        SubstanceLookAndFeel.currentTitlePainter = currentTitlePainter;
        if (toReset) {
            ButtonBackgroundDelegate.reset();
            SubstanceCheckBoxUI.reset();
            SubstanceRadioButtonUI.reset();
        }
        for (TitlePainterChangeListener titlePainterChangeListener : titlePainterChangeListeners) {
            titlePainterChangeListener.titlePainterChanged();
        }
        return true;
    }

    @Override
    public String getDescription() {
        return "Substance Look and Feel by Kirill Grouchnikov";
    }

    @Override
    public String getID() {
        return "Substance";
    }

    @Override
    public String getName() {
        return "Substance";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return false;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    protected void __org__jvnet__substance__SubstanceLookAndFeel__initClassDefaults(UIDefaults table) {
        super.initClassDefaults(table);
        String UI_CLASSNAME_PREFIX = "org.jvnet.substance.Substance";
        Object[] uiDefaults = new Object[]{"ButtonUI", UI_CLASSNAME_PREFIX + "ButtonUI", "CheckBoxUI", UI_CLASSNAME_PREFIX + "CheckBoxUI", "ComboBoxUI", UI_CLASSNAME_PREFIX + "ComboBoxUI", "CheckBoxMenuItemUI", UI_CLASSNAME_PREFIX + "CheckBoxMenuItemUI", "DesktopIconUI", UI_CLASSNAME_PREFIX + "DesktopIconUI", "DesktopPaneUI", UI_CLASSNAME_PREFIX + "DesktopPaneUI", "EditorPaneUI", UI_CLASSNAME_PREFIX + "EditorPaneUI", "FileChooserUI", UI_CLASSNAME_PREFIX + "FileChooserUI", "FormattedTextFieldUI", UI_CLASSNAME_PREFIX + "FormattedTextFieldUI", "InternalFrameUI", UI_CLASSNAME_PREFIX + "InternalFrameUI", "ListUI", UI_CLASSNAME_PREFIX + "ListUI", "MenuUI", UI_CLASSNAME_PREFIX + "MenuUI", "MenuBarUI", UI_CLASSNAME_PREFIX + "MenuBarUI", "MenuItemUI", UI_CLASSNAME_PREFIX + "MenuItemUI", "OptionPaneUI", UI_CLASSNAME_PREFIX + "OptionPaneUI", "PanelUI", UI_CLASSNAME_PREFIX + "PanelUI", "PasswordFieldUI", UI_CLASSNAME_PREFIX + "PasswordFieldUI", "PopupMenuUI", UI_CLASSNAME_PREFIX + "PopupMenuUI", "PopupMenuSeparatorUI", UI_CLASSNAME_PREFIX + "PopupMenuSeparatorUI", "ProgressBarUI", UI_CLASSNAME_PREFIX + "ProgressBarUI", "RadioButtonUI", UI_CLASSNAME_PREFIX + "RadioButtonUI", "RadioButtonMenuItemUI", UI_CLASSNAME_PREFIX + "RadioButtonMenuItemUI", "RootPaneUI", UI_CLASSNAME_PREFIX + "RootPaneUI", "ScrollBarUI", UI_CLASSNAME_PREFIX + "ScrollBarUI", "ScrollPaneUI", UI_CLASSNAME_PREFIX + "ScrollPaneUI", "SeparatorUI", UI_CLASSNAME_PREFIX + "SeparatorUI", "SliderUI", UI_CLASSNAME_PREFIX + "SliderUI", "SpinnerUI", UI_CLASSNAME_PREFIX + "SpinnerUI", "SplitPaneUI", UI_CLASSNAME_PREFIX + "SplitPaneUI", "TabbedPaneUI", UI_CLASSNAME_PREFIX + "TabbedPaneUI", "TableUI", UI_CLASSNAME_PREFIX + "TableUI", "TableHeaderUI", UI_CLASSNAME_PREFIX + "TableHeaderUI", "TextAreaUI", UI_CLASSNAME_PREFIX + "TextAreaUI", "TextFieldUI", UI_CLASSNAME_PREFIX + "TextFieldUI", "TextPaneUI", UI_CLASSNAME_PREFIX + "TextPaneUI", "ToggleButtonUI", UI_CLASSNAME_PREFIX + "ToggleButtonUI", "ToolBarUI", UI_CLASSNAME_PREFIX + "ToolBarUI", "TreeUI", UI_CLASSNAME_PREFIX + "TreeUI"};
        table.putDefaults(uiDefaults);
    }

    @Override
    protected void initComponentDefaults(UIDefaults table) {
        super.initComponentDefaults(table);
        String fontFamilyName = SubstanceLookAndFeel.getFontFamilyName();
        int regKind = SubstanceLookAndFeel.isBasicFontBold() ? 1 : 0;
        int baseFontSize = SubstanceLookAndFeel.getBasicFontSize();
        FontUIResource fontPlainBase = new FontUIResource(new Font(fontFamilyName, regKind, baseFontSize));
        FontUIResource fontBoldBase = new FontUIResource(new Font(fontFamilyName, 1, baseFontSize));
        FontUIResource fontBoldBaseP1 = new FontUIResource(new Font(fontFamilyName, 1, baseFontSize + 1));
        Object[] fontDefaults = new Object[]{"Button.font", fontPlainBase, "CheckBox.font", fontPlainBase, "CheckBoxMenuItem.font", fontPlainBase, "CheckBoxMenuItem.acceleratorFont", fontPlainBase, "ComboBox.font", fontPlainBase, "DesktopIcon.font", fontBoldBaseP1, "EditorPane.font", fontPlainBase, "FormattedTextField.font", fontPlainBase, "InternalFrame.titleFont", fontBoldBaseP1, "Label.font", fontPlainBase, "List.font", fontPlainBase, "Menu.font", fontPlainBase, "Menu.acceleratorFont", fontPlainBase, "MenuBar.font", fontPlainBase, "MenuItem.font", fontPlainBase, "MenuItem.acceleratorFont", fontPlainBase, "OptionPane.font", fontPlainBase, "OptionPane.messageFont", fontPlainBase, "OptionPane.buttonFont", fontPlainBase, "Panel.font", fontPlainBase, "PasswordField.font", fontPlainBase, "PopupMenu.font", fontPlainBase, "ProgressBar.font", fontPlainBase, "RadioButton.font", fontPlainBase, "RadioButtonMenuItem.font", fontPlainBase, "RadioButtonMenuItem.acceleratorFont", fontPlainBase, "ScrollPane.font", fontPlainBase, "Spinner.font", fontPlainBase, "TabbedPane.font", fontPlainBase, "Table.font", fontPlainBase, "TableHeader.font", fontPlainBase, "TextField.font", fontPlainBase, "TextPane.font", fontPlainBase, "ToolBar.font", fontPlainBase, "ToggleButton.font", fontPlainBase, "Tree.font", fontPlainBase, "Viewport.font", fontPlainBase, "Spinner.font", fontPlainBase, "TextArea.font", fontPlainBase, "TitledBorder.font", fontBoldBase, "ToolTip.font", fontPlainBase};
        table.putDefaults(fontDefaults);
        SubstanceLookAndFeel.getTheme().addCustomEntriesToTable(table);
    }

    @Override
    public UIDefaults getDefaults() {
        UIDefaults table = super.getDefaults();
        componentPlugins.processAllDefaultsEntries(table, currentTheme);
        return table;
    }

    @Override
    public void initialize() {
        String heapStatusPanelParam;
        String paramTraceFile;
        Float imageWatermarkOpacity;
        super.initialize();
        ShadowPopupFactory.install();
        if (currentTheme == null) {
            String paramTheme = paramReader.getThemeProperty();
            boolean isSetTheme = false;
            if (paramTheme != null) {
                isSetTheme = SubstanceLookAndFeel.setCurrentTheme(paramTheme, false);
            }
            if (!isSetTheme) {
                try {
                    Object themePlugin;
                    String defaultThemeClassName;
                    Iterator i$ = themePlugins.getAvailablePlugins(true).iterator();
                    while (i$.hasNext() && ((defaultThemeClassName = ((SubstanceThemePlugin)(themePlugin = i$.next())).getDefaultThemeClassName()) == null || !(isSetTheme = SubstanceLookAndFeel.setCurrentTheme(defaultThemeClassName, false)))) {
                    }
                    if (!isSetTheme) {
                        SubstanceLookAndFeel.setCurrentTheme(new SubstanceAquaTheme(), false);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        } else {
            SubstanceLookAndFeel.setCurrentTheme(currentTheme, false);
        }
        SubstanceConstants.ImageWatermarkKind imageWatermarkKind = paramReader.getWatermarkImageKindProperty();
        if (imageWatermarkKind != null) {
            SubstanceLookAndFeel.setImageWatermarkKind(imageWatermarkKind);
        }
        if ((imageWatermarkOpacity = paramReader.getWatermarkImageOpacityProperty()) != null) {
            SubstanceLookAndFeel.setImageWatermarkOpacity(imageWatermarkOpacity.floatValue());
        }
        if (currentWatermark == null) {
            String paramWatermark = paramReader.getWatermarkProperty();
            boolean isSetWatermark = false;
            if (paramWatermark != null) {
                isSetWatermark = SubstanceLookAndFeel.setCurrentWatermark(paramWatermark, paramReader);
            }
            if (!isSetWatermark) {
                try {
                    Object watermarkPlugin;
                    String defaultWatermarkClassName;
                    Iterator i$ = watermarkPlugins.getAvailablePlugins(true).iterator();
                    while (i$.hasNext() && ((defaultWatermarkClassName = ((SubstanceWatermarkPlugin)(watermarkPlugin = i$.next())).getDefaultWatermarkClassName()) == null || !(isSetWatermark = SubstanceLookAndFeel.setCurrentWatermark(defaultWatermarkClassName, paramReader)))) {
                    }
                    if (!isSetWatermark) {
                        SubstanceLookAndFeel.setCurrentWatermark(new SubstanceStripeWatermark());
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        if (currentButtonShaper == null) {
            String paramButtonShaper = paramReader.getButtonShaperProperty();
            boolean isSetButtonShaper = false;
            if (paramButtonShaper != null) {
                isSetButtonShaper = SubstanceLookAndFeel.setCurrentButtonShaper(paramButtonShaper, false);
            }
            if (!isSetButtonShaper) {
                try {
                    for (Object buttonShaperPlugin : shaperPlugins.getAvailablePlugins(true)) {
                        for (ButtonShaperInfo buttonShaperInfo : ((SubstanceButtonShaperPlugin)buttonShaperPlugin).getButtonShapers()) {
                            if (!buttonShaperInfo.isDefault()) continue;
                            isSetButtonShaper = SubstanceLookAndFeel.setCurrentButtonShaper(buttonShaperInfo.getClassName(), false);
                        }
                    }
                    if (!isSetButtonShaper) {
                        SubstanceLookAndFeel.setCurrentButtonShaper(new StandardButtonShaper(), false);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        if (currentGradientPainter == null) {
            String paramGradientPainter = paramReader.getGradientPainterProperty();
            boolean isSetGradientPainter = false;
            if (paramGradientPainter != null) {
                isSetGradientPainter = SubstanceLookAndFeel.setCurrentGradientPainter(paramGradientPainter);
            }
            if (!isSetGradientPainter) {
                try {
                    for (Object gradientPainterPlugin : painterPlugins.getAvailablePlugins(true)) {
                        for (GradientPainterInfo gradientPainterInfo : ((SubstanceGradientPainterPlugin)gradientPainterPlugin).getGradientPainters()) {
                            if (!gradientPainterInfo.isDefault()) continue;
                            isSetGradientPainter = SubstanceLookAndFeel.setCurrentGradientPainter(gradientPainterInfo.getClassName());
                        }
                    }
                    if (!isSetGradientPainter) {
                        SubstanceLookAndFeel.setCurrentGradientPainter(new StandardGradientPainter(), false);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        if (currentTitlePainter == null) {
            String paramTitlePainter = paramReader.getTitlePainterProperty();
            boolean isSetTitlePainter = false;
            if (paramTitlePainter != null) {
                isSetTitlePainter = SubstanceLookAndFeel.setCurrentTitlePainter(paramTitlePainter);
            }
            if (!isSetTitlePainter) {
                try {
                    for (Object titlePainterPlugin : titlePainterPlugins.getAvailablePlugins(true)) {
                        for (TitlePainterInfo titlePainterInfo : ((SubstanceTitlePainterPlugin)titlePainterPlugin).getTitlePainters()) {
                            if (!titlePainterInfo.isDefault()) continue;
                            isSetTitlePainter = SubstanceLookAndFeel.setCurrentTitlePainter(titlePainterInfo.getClassName());
                        }
                    }
                    if (!isSetTitlePainter) {
                        SubstanceLookAndFeel.setCurrentTitlePainter(new Glass3DTitlePainter(), false);
                    }
                }
                catch (Exception exc) {
                    exc.printStackTrace();
                }
            }
        }
        if ((paramTraceFile = paramReader.getTraceFileNameProperty()) != null) {
            MemoryAnalyzer.commence(1000L, paramTraceFile);
            for (Object plugin : componentPlugins.getAvailablePlugins(true)) {
                MemoryAnalyzer.enqueueUsage("Has plugin '" + plugin.getClass().getName() + "'");
            }
            for (Object plugin : themePlugins.getAvailablePlugins(true)) {
                MemoryAnalyzer.enqueueUsage("Has theme plugin '" + plugin.getClass().getName() + "'");
            }
            for (Object plugin : watermarkPlugins.getAvailablePlugins(true)) {
                MemoryAnalyzer.enqueueUsage("Has watermark plugin '" + plugin.getClass().getName() + "'");
            }
            for (Object plugin : shaperPlugins.getAvailablePlugins(true)) {
                MemoryAnalyzer.enqueueUsage("Has button shaper plugin '" + plugin.getClass().getName() + "'");
            }
        }
        SubstanceTitlePane.setCanHaveHeapStatusPanel((heapStatusPanelParam = paramReader.toShowHeapStatusPanelProperty()) != null);
        SubstanceTitlePane.setHeapStatusLogfileName(heapStatusPanelParam);
        toShowExtraElements = paramReader.toShowExtraElementProperty();
        toEnableInvertedThemes = paramReader.toEnableInvertedThemes();
        toEnableNegatedThemes = paramReader.toEnableNegatedThemes();
        toBleedWatermark = paramReader.toBleedWatermark();
        isDebugUiMode = paramReader.isDebugUiMode();
        if (!isFontSizeExtraSet) {
            baseFontSize = LookUtils.IS_OS_MAC ? 13 : 11;
            fontSizeExtra = 0;
            isFontBold = false;
            String paramFontSizeExtra = paramReader.getFontSizeExtraProperty();
            if (paramFontSizeExtra != null) {
                if (paramFontSizeExtra.endsWith("+")) {
                    isFontBold = true;
                    paramFontSizeExtra = paramFontSizeExtra.substring(0, paramFontSizeExtra.length() - 1);
                } else if (paramFontSizeExtra.endsWith("-")) {
                    isFontBold = false;
                    paramFontSizeExtra = paramFontSizeExtra.substring(0, paramFontSizeExtra.length() - 1);
                }
                fontSizeExtra = Integer.parseInt(paramFontSizeExtra);
            }
            isFontSizeExtraSet = true;
        }
        try {
            Class.forName("org.jvnet.lafwidget.menu.MenuSearchWidget");
            SubstanceMenuBarUI.showSearchPanels();
        }
        catch (ClassNotFoundException cnfe) {
            // empty catch block
        }
        componentPlugins.initializeAll();
        LafWidgetRepository.getRepository().setLafSupport(new SubstanceWidgetSupport());
    }

    @Override
    public void uninitialize() {
        super.uninitialize();
        ShadowPopupFactory.uninstall();
        SubstanceLookAndFeel.stopThreads();
        try {
            Class.forName("org.jvnet.lafwidget.menu.MenuSearchWidget");
            SubstanceMenuBarUI.hideSearchPanels(false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        currentWatermark.dispose();
        componentPlugins.uninitializeAll();
        LafWidgetRepository.getRepository().unsetLafSupport();
    }

    public static void stopThreads() {
        PulseTracker.stopAllTimers();
        FadeTracker.getInstance().stopAllTimers();
        TrackableThread.requestStopAllThreads();
    }

    public static Set getPlugins() {
        return Collections.unmodifiableSet(componentPlugins.getAvailablePlugins(true));
    }

    public static void registerSkinChangeListener(SkinChangeListener skinChangeListener) {
        skinChangeListeners.add(skinChangeListener);
    }

    public static void unregisterSkinChangeListener(SkinChangeListener skinChangeListener) {
        skinChangeListeners.remove(skinChangeListener);
    }

    public static void registerThemeChangeListener(ThemeChangeListener themeChangeListener) {
        themeChangeListeners.add(themeChangeListener);
    }

    public static void unregisterThemeChangeListener(ThemeChangeListener themeChangeListener) {
        themeChangeListeners.remove(themeChangeListener);
    }

    public static void registerWatermarkChangeListener(WatermarkChangeListener watermarkChangeListener) {
        watermarkChangeListeners.add(watermarkChangeListener);
    }

    public static void unregisterWatermarkChangeListener(WatermarkChangeListener watermarkChangeListener) {
        watermarkChangeListeners.remove(watermarkChangeListener);
    }

    public static void registerButtonShaperChangeListener(ButtonShaperChangeListener buttonShaperChangeListener) {
        buttonShaperChangeListeners.add(buttonShaperChangeListener);
    }

    public static void unregisterButtonShaperChangeListener(ButtonShaperChangeListener buttonShaperChangeListener) {
        buttonShaperChangeListeners.remove(buttonShaperChangeListener);
    }

    public static void registerGradientPainterChangeListener(GradientPainterChangeListener gradientPainterChangeListener) {
        gradientPainterChangeListeners.add(gradientPainterChangeListener);
    }

    public static void unregisterGradientPainterChangeListener(GradientPainterChangeListener gradientPainterChangeListener) {
        gradientPainterChangeListeners.remove(gradientPainterChangeListener);
    }

    public static void registerTitlePainterChangeListener(TitlePainterChangeListener titlePainterChangeListener) {
        titlePainterChangeListeners.add(titlePainterChangeListener);
    }

    public static void unregisterTitlePainterChangeListener(TitlePainterChangeListener titlePainterChangeListener) {
        titlePainterChangeListeners.remove(titlePainterChangeListener);
    }

    public static void registerTabCloseChangeListener(BaseTabCloseListener tabCloseListener) {
        TabCloseListenerManager.getInstance().registerListener(tabCloseListener);
    }

    public static void registerTabCloseChangeListener(JTabbedPane tabbedPane, BaseTabCloseListener tabCloseListener) {
        TabCloseListenerManager.getInstance().registerListener(tabbedPane, tabCloseListener);
    }

    public static void unregisterTabCloseChangeListener(BaseTabCloseListener tabCloseListener) {
        TabCloseListenerManager.getInstance().unregisterListener(tabCloseListener);
    }

    public static void unregisterTabCloseChangeListener(JTabbedPane tabbedPane, BaseTabCloseListener tabCloseListener) {
        TabCloseListenerManager.getInstance().unregisterListener(tabbedPane, tabCloseListener);
    }

    public static Set<BaseTabCloseListener> getAllTabCloseListeners() {
        return TabCloseListenerManager.getInstance().getListeners();
    }

    @Deprecated
    public static Set<TabCloseListener> getTabCloseListeners() {
        HashSet<TabCloseListener> result = new HashSet<TabCloseListener>();
        for (BaseTabCloseListener listener : TabCloseListenerManager.getInstance().getListeners()) {
            if (!(listener instanceof TabCloseListener)) continue;
            result.add((TabCloseListener)listener);
        }
        return result;
    }

    public static Set<BaseTabCloseListener> getAllTabCloseListeners(JTabbedPane tabbedPane) {
        return TabCloseListenerManager.getInstance().getListeners(tabbedPane);
    }

    @Deprecated
    public static Set<TabCloseListener> getTabCloseListeners(JTabbedPane tabbedPane) {
        HashSet<TabCloseListener> result = new HashSet<TabCloseListener>();
        for (BaseTabCloseListener listener : TabCloseListenerManager.getInstance().getListeners(tabbedPane)) {
            if (!(listener instanceof TabCloseListener)) continue;
            result.add((TabCloseListener)listener);
        }
        return result;
    }

    public static void registerLocaleChangeListener(LocaleChangeListener localeListener) {
        localeChangeListeners.add(localeListener);
    }

    public static void unregisterLocaleChangeListener(LocaleChangeListener localeListener) {
        localeChangeListeners.remove(localeListener);
    }

    public static Set<LocaleChangeListener> getLocaleListeners() {
        return Collections.unmodifiableSet(localeChangeListeners);
    }

    public static boolean isTahomaAvailable() {
        Locale curLocale = Locale.getDefault();
        if (Locale.JAPANESE.getLanguage().equals(curLocale.getLanguage()) || Locale.KOREAN.getLanguage().equals(curLocale.getLanguage()) || Locale.CHINESE.getLanguage().equals(curLocale.getLanguage())) {
            return false;
        }
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] familyNames = env.getAvailableFontFamilyNames();
        for (int i = 0; i < familyNames.length; ++i) {
            if (!"Tahoma".equals(familyNames[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean toShowExtraElements() {
        if (!toShowExtraElements) {
            return false;
        }
        return !Boolean.TRUE.equals(UIManager.get(NO_EXTRA_ELEMENTS));
    }

    public static boolean toEnableInvertedThemes() {
        if (toEnableInvertedThemes) {
            return true;
        }
        return Boolean.TRUE.equals(UIManager.get(ENABLE_INVERTED_THEMES));
    }

    public static boolean toEnableNegatedThemes() {
        if (toEnableNegatedThemes) {
            return true;
        }
        return Boolean.TRUE.equals(UIManager.get(ENABLE_NEGATED_THEMES));
    }

    public static boolean toBleedWatermark() {
        if (toBleedWatermark) {
            return true;
        }
        return Boolean.TRUE.equals(UIManager.get(WATERMARK_TO_BLEED));
    }

    public static boolean isDebugUiMode() {
        if (isDebugUiMode) {
            return true;
        }
        return Boolean.TRUE.equals(UIManager.get(DEBUG_UI_MODE));
    }

    public static int getBasicFontSize() {
        return baseFontSize + fontSizeExtra;
    }

    public static void setBasicFontSize(int value) {
        baseFontSize = value;
    }

    public static void setFontSizeExtra(int value) {
        fontSizeExtra = value;
    }

    public static String getFontFamilyName() {
        if (LookUtils.IS_OS_MAC) {
            return "Lucida Grande";
        }
        if (SubstanceLookAndFeel.isTahomaAvailable()) {
            return "Tahoma";
        }
        return "dialog";
    }

    public static boolean isBasicFontBold() {
        return isFontBold;
    }

    public static ParamReader getParamReader() {
        return paramReader;
    }

    public static void hideMenuSearchPanels() {
        SubstanceMenuBarUI.hideSearchPanels(true);
    }

    public static void showMenuSearchPanels() {
        SubstanceMenuBarUI.showSearchPanels();
    }

    public static void ignoreAnimationsOnClass(Class<?> componentClazz) {
        ignoreAnimationsSet.add(componentClazz.getName());
    }

    public static void ignoreAnimationsOnClass(String componentClazzName) {
        ignoreAnimationsSet.add(componentClazzName);
    }

    public static boolean toIgnoreAnimation(Class<?> componentClazz) {
        return ignoreAnimationsSet.contains(componentClazz.getName());
    }

    public static void permanentlyShowHeapStatusPanel(JRootPane pane) {
        if (!SubstanceTitlePane.getCanHaveHeapStatusPanel()) {
            throw new IllegalArgumentException("This function can only be called when heap status panel functionality is enabled");
        }
        ((SubstanceRootPaneUI)pane.getUI()).setHeapStatusPanePermanentVisibility(true);
    }

    public static void permanentlyHideHeapStatusPanel(JRootPane pane) {
        if (!SubstanceTitlePane.getCanHaveHeapStatusPanel()) {
            throw new IllegalArgumentException("This function can only be called when heap status panel functionality is enabled");
        }
        ((SubstanceRootPaneUI)pane.getUI()).setHeapStatusPanePermanentVisibility(false);
    }

    public static void setImageWatermarkKind(SubstanceConstants.ImageWatermarkKind kind) {
        SubstanceImageWatermark.setKind(kind);
        if (currentWatermark instanceof SubstanceImageWatermark) {
            currentWatermark.updateWatermarkImage();
        }
    }

    public static SubstanceConstants.ImageWatermarkKind getImageWatermarkKind() {
        return SubstanceImageWatermark.getKind();
    }

    public static void setImageWatermarkOpacity(float opacity) {
        SubstanceImageWatermark.setOpacity(opacity);
        if (currentWatermark instanceof SubstanceImageWatermark) {
            currentWatermark.updateWatermarkImage();
        }
    }

    public static float getImageWatermarkOpacity() {
        return SubstanceImageWatermark.getOpacity();
    }

    public static void addMixedTheme(SubstanceMixTheme mixedTheme) {
        if (mixedThemes.containsKey(mixedTheme.getDisplayName())) {
            return;
        }
        mixedThemes.put(mixedTheme.getDisplayName(), mixedTheme);
    }

    public static void addMixedTheme(SubstanceTheme ... themes) {
        SubstanceLookAndFeel.addMixedTheme(new SubstanceMixTheme(themes));
    }

    public static void addMixedThemeBy(SubstanceTheme mainTheme) {
        SubstanceTheme.ThemeKind mainThemeKind = mainTheme.getKind();
        if (mainThemeKind == SubstanceTheme.ThemeKind.BRIGHT || mainThemeKind == SubstanceTheme.ThemeKind.COLD) {
            for (ThemeInfo themeInfo : SubstanceLookAndFeel.getAllThemes().values()) {
                SubstanceTheme.ThemeKind themeKind = themeInfo.getThemeKind();
                if (themeKind != mainTheme.getKind() || themeInfo.getDisplayName().equals(mainTheme.getDisplayName())) continue;
                try {
                    Object obj;
                    Class<?> themeClass = Class.forName(themeInfo.getClassName());
                    if (themeClass == null || (obj = themeClass.newInstance()) == null || !(obj instanceof SubstanceTheme)) continue;
                    SubstanceLookAndFeel.addMixedTheme(new SubstanceMixTheme(mainTheme, (SubstanceTheme)obj));
                }
                catch (Exception exc) {}
            }
        }
    }

    public static void removeMixedTheme(SubstanceMixTheme mixedTheme) {
        mixedThemes.remove(mixedTheme.getDisplayName());
    }

    public static void removeMixedThemeBy(SubstanceTheme mainTheme) {
        Iterator<Map.Entry<String, SubstanceMixTheme>> it = mixedThemes.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, SubstanceMixTheme> entry = it.next();
            if (!entry.getValue().getOriginalThemes()[0].getDisplayName().equals(mainTheme.getDisplayName())) continue;
            it.remove();
        }
    }

    public static boolean hasMixedThemes() {
        return mixedThemes.size() > 0;
    }

    public static boolean isToUseConstantThemesOnDialogs() {
        return toUseConstantThemesOnDialogs;
    }

    public static void setToUseConstantThemesOnDialogs(boolean toUseConstantThemesOnDialogs) {
        SubstanceLookAndFeel.toUseConstantThemesOnDialogs = toUseConstantThemesOnDialogs;
    }

    public static void setRootPaneCustomTitleButtons(JRootPane rootPane, List<TitleButtonInfo> infoList) {
        TitleButtonManager.getManager().addRootPaneCustomTitleButtons(rootPane, infoList, false);
    }

    public static void removeRootPaneCustomTitleButtons(JRootPane rootPane) {
        TitleButtonManager.getManager().removeRootPaneCustomTitleButtons(rootPane);
    }

    public static boolean setSkin(SubstanceSkin skin) {
        try {
            if (!skin.set()) {
                return false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    for (Frame frame : Frame.getFrames()) {
                        SwingUtilities.updateComponentTreeUI(frame);
                    }
                    for (SkinChangeListener skinChangeListener : skinChangeListeners) {
                        skinChangeListener.skinChanged();
                    }
                }
            });
            return true;
        }
        catch (NoClassDefFoundError ncdfe) {
            return false;
        }
    }

    public static boolean setSkin(String skinClassName) {
        try {
            Class<?> skinClass = Class.forName(skinClassName);
            if (skinClass == null) {
                return false;
            }
            Object obj = skinClass.newInstance();
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof SubstanceSkin)) {
                return false;
            }
            return SubstanceLookAndFeel.setSkin((SubstanceSkin)obj);
        }
        catch (Exception exc) {
            return false;
        }
    }

    public static Map<String, SkinInfo> getAllSkins() {
        TreeMap<String, SkinInfo> result = new TreeMap<String, SkinInfo>();
        for (Object skinPlugin : skinPlugins.getAvailablePlugins(true)) {
            for (SkinInfo skinInfo : ((SubstanceSkinPlugin)skinPlugin).getSkins()) {
                result.put(skinInfo.getDisplayName(), skinInfo);
            }
        }
        return result;
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public static void setLabelBundleClassLoader(ClassLoader labelBundleClassLoader) {
        SubstanceLookAndFeel.labelBundleClassLoader = labelBundleClassLoader;
        LafWidgetRepository.setLabelBundleClassLoader(labelBundleClassLoader);
    }

    public static JComponent getTitlePaneComponent(Window window) {
        JRootPane rootPane = null;
        if (window instanceof JFrame) {
            JFrame f = (JFrame)window;
            rootPane = f.getRootPane();
        }
        if (window instanceof JDialog) {
            JDialog d = (JDialog)window;
            rootPane = d.getRootPane();
        }
        if (rootPane != null) {
            SubstanceRootPaneUI ui = (SubstanceRootPaneUI)rootPane.getUI();
            return ui.getTitlePane();
        }
        return null;
    }

    public static synchronized void setBackgroundComposite(Class<?> clazz, ControlBackgroundComposite composite) {
        backgroundComposites.put(clazz, composite);
    }

    public static synchronized ControlBackgroundComposite getBackgroundComposite(Component component) {
        ControlBackgroundComposite result = backgroundComposites.get(component.getClass());
        if (result == null) {
            result = new DefaultControlBackgroundComposite();
        }
        return result;
    }

    public static SubstanceConstants.PinState getPinState(Component comp) {
        if (!SubstanceCoreUtilities.canBePinned(comp)) {
            return SubstanceConstants.PinState.CANNOT_BE_PINNED;
        }
        if (SubstanceCoreUtilities.isPermanentlyPinned(comp)) {
            return SubstanceConstants.PinState.PERMANENTLY_PINNED;
        }
        if (comp instanceof JComponent) {
            if (Boolean.TRUE.equals(((JComponent)comp).getClientProperty("substancelaf.internal.internalFramePinned"))) {
                return SubstanceConstants.PinState.PINNED;
            }
            return SubstanceConstants.PinState.NOT_PINNED;
        }
        return null;
    }

    static {
        skinChangeListeners = new HashSet<SkinChangeListener>();
        themeChangeListeners = new HashSet<ThemeChangeListener>();
        watermarkChangeListeners = new HashSet<WatermarkChangeListener>();
        buttonShaperChangeListeners = new HashSet<ButtonShaperChangeListener>();
        gradientPainterChangeListeners = new HashSet<GradientPainterChangeListener>();
        titlePainterChangeListeners = new HashSet<TitlePainterChangeListener>();
        localeChangeListeners = new HashSet<LocaleChangeListener>();
        ignoreAnimationsSet = new HashSet<String>();
        mixedThemes = new HashMap<String, SubstanceMixTheme>();
        backgroundComposites = new HashMap();
        BORDER_ANIMATION_KIND = new FadeTracker.FadeKind("substancelaf.borderAnimation");
        LABEL_BUNDLE = null;
        currentTheme = null;
        currentWatermark = null;
        currentButtonShaper = null;
        currentGradientPainter = null;
        currentTitlePainter = null;
    }
}

