/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.GeneralPath;
import java.awt.image.BufferedImage;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import org.jvnet.lafwidget.utils.FadeTracker;
import org.jvnet.substance.SubstanceImageCreator;
import org.jvnet.substance.button.BaseButtonShaper;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.painter.ControlBackgroundComposite;
import org.jvnet.substance.painter.SimplisticSoftBorderReverseGradientPainter;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.utils.ComponentState;
import org.jvnet.substance.utils.SubstanceConstants;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public class PairwiseButtonBackgroundDelegate {
    private static Map<String, BufferedImage> pairwiseBackgrounds = new HashMap<String, BufferedImage>();

    public static synchronized void reset() {
        pairwiseBackgrounds.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getPairwiseBackground(AbstractButton button, ComponentState.ColorSchemeKind kind, SubstanceGradientPainter painter, int width, int height, SubstanceConstants.Side side, boolean toIgnoreOpenSides) {
        ColorScheme colorScheme;
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return null;
        }
        BufferedImage resultNonFlat = null;
        ComponentState state = ComponentState.getState(button.getModel(), button);
        float cyclePos = state.getCycleCount();
        ControlBackgroundComposite controlComposite = SubstanceCoreUtilities.getControlBackgroundComposite(button);
        ColorScheme colorScheme2 = colorScheme = SubstanceCoreUtilities.getComponentTheme(button, kind, true).getColorScheme();
        FadeTracker fadeTracker = FadeTracker.getInstance();
        if (fadeTracker.isTracked(button, FadeTracker.FadeKind.ROLLOVER)) {
            Composite defaultComposite = controlComposite.getBackgroundComposite(button, button.getParent(), -1, false);
            Composite activeComposite = controlComposite.getBackgroundComposite(button, button.getParent(), -1, true);
            boolean isActive = SubstanceCoreUtilities.isControlAlwaysPaintedActive(button, true);
            ColorScheme defaultScheme = SubstanceCoreUtilities.getDefaultScheme(button);
            if (state == ComponentState.DEFAULT) {
                colorScheme2 = SubstanceCoreUtilities.getActiveScheme(button);
                colorScheme = isActive ? colorScheme : defaultScheme;
                cyclePos = fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
            }
            if (state == ComponentState.ROLLOVER_UNSELECTED) {
                colorScheme2 = colorScheme;
                colorScheme = isActive ? colorScheme : defaultScheme;
                cyclePos = fadeTracker.getFade10(button, FadeTracker.FadeKind.ROLLOVER);
            }
            BufferedImage imageDefault = PairwiseButtonBackgroundDelegate.getPairwiseBackground(button, painter, width, height, side, cyclePos, colorScheme, colorScheme2, defaultComposite, toIgnoreOpenSides);
            BufferedImage imageActive = PairwiseButtonBackgroundDelegate.getPairwiseBackground(button, painter, width, height, side, cyclePos, colorScheme, colorScheme2, activeComposite, toIgnoreOpenSides);
            if (imageDefault == null) {
                return null;
            }
            Graphics2D graphics = imageDefault.createGraphics();
            graphics.setComposite(AlphaComposite.getInstance(3, cyclePos / 10.0f));
            graphics.drawImage((Image)imageActive, 0, 0, null);
            resultNonFlat = imageDefault;
        } else {
            Composite graphicsComposite = controlComposite.getBackgroundComposite(button, button.getParent(), 0, ComponentState.getState(button.getModel(), null).getColorSchemeKind() == ComponentState.ColorSchemeKind.CURRENT);
            resultNonFlat = PairwiseButtonBackgroundDelegate.getPairwiseBackground(button, painter, width, height, side, cyclePos, colorScheme, colorScheme2, graphicsComposite, toIgnoreOpenSides);
        }
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(width, height);
        Graphics2D resultGr = result.createGraphics();
        if (SubstanceCoreUtilities.hasFlatProperty(button.getParent())) {
            BufferedImage temp = SubstanceCoreUtilities.getBlankImage(resultNonFlat.getWidth(), resultNonFlat.getHeight());
            Graphics2D tempGr = temp.createGraphics();
            try {
                if (FadeTracker.getInstance().isTracked(button, FadeTracker.FadeKind.ROLLOVER) && !state.isSelected() && state.isEnabled()) {
                    float fadeCoef = FadeTracker.getInstance().getFade10(button, FadeTracker.FadeKind.ROLLOVER);
                    tempGr.setComposite(AlphaComposite.getInstance(3, fadeCoef / 10.0f));
                    tempGr.drawImage((Image)resultNonFlat, 0, 0, null);
                } else if (state != ComponentState.DISABLED_UNSELECTED && state != ComponentState.DEFAULT) {
                    tempGr.drawImage((Image)resultNonFlat, 0, 0, null);
                }
                resultGr.drawImage((Image)temp, 0, 0, null);
            }
            finally {
                tempGr.dispose();
            }
        } else {
            resultGr.drawImage((Image)resultNonFlat, 0, 0, null);
        }
        return result;
    }

    private static synchronized BufferedImage getPairwiseBackground(AbstractButton button, SubstanceGradientPainter painter, int width, int height, SubstanceConstants.Side side, float cyclePos, ColorScheme colorScheme, ColorScheme colorScheme2, Composite graphicsComposite, boolean toIgnoreOpenSides) {
        if (SubstanceCoreUtilities.isButtonNeverPainted(button)) {
            return null;
        }
        Set<Object> openSides = toIgnoreOpenSides ? new HashSet() : SubstanceCoreUtilities.getSides(button, "substancelaf.buttonopenSide");
        String openKey = "";
        for (SubstanceConstants.Side side2 : openSides) {
            openKey = openKey + side2.name() + "-";
        }
        String sideKey = side == null ? "null" : side.toString();
        String string = width + ":" + height + ":" + sideKey + ":" + cyclePos + ":" + openKey + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme) + ":" + SubstanceCoreUtilities.getSchemeId(colorScheme2) + ":" + button.getClass().getName() + ":" + painter.getDisplayName();
        if (!pairwiseBackgrounds.containsKey(string)) {
            BufferedImage newBackground = null;
            boolean radius = false;
            int deltaLeft = openSides.contains((Object)SubstanceConstants.Side.LEFT) ? 3 : 0;
            int deltaRight = openSides.contains((Object)SubstanceConstants.Side.RIGHT) ? 3 : 0;
            int deltaTop = openSides.contains((Object)SubstanceConstants.Side.TOP) ? 3 : 0;
            int deltaBottom = openSides.contains((Object)SubstanceConstants.Side.BOTTOM) ? 3 : 0;
            GeneralPath contour = null;
            if (side != null) {
                switch (side) {
                    case TOP: 
                    case BOTTOM: {
                        contour = BaseButtonShaper.getBaseOutline(height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, (float)radius, null);
                        newBackground = painter.getContourBackground(height + deltaTop + deltaBottom, width + deltaLeft + deltaRight, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                        newBackground = SubstanceImageCreator.getRotated(newBackground, 3);
                        break;
                    }
                    case RIGHT: 
                    case LEFT: {
                        contour = BaseButtonShaper.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, (float)radius, null);
                        newBackground = painter.getContourBackground(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
                    }
                }
            } else {
                contour = BaseButtonShaper.getBaseOutline(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, (float)radius, null);
                newBackground = painter.getContourBackground(width + deltaLeft + deltaRight, height + deltaTop + deltaBottom, contour, false, colorScheme, colorScheme2, cyclePos, true, colorScheme != colorScheme2);
            }
            BufferedImage finalBackground = SubstanceCoreUtilities.getBlankImage(width, height);
            Graphics2D finalGraphics = (Graphics2D)finalBackground.getGraphics();
            finalGraphics.drawImage(newBackground, -deltaLeft, -deltaTop, null);
            pairwiseBackgrounds.put(string, finalBackground);
        }
        BufferedImage opaque = pairwiseBackgrounds.get(string);
        BufferedImage result = SubstanceCoreUtilities.getBlankImage(opaque.getWidth(), opaque.getHeight());
        Graphics2D resultGr = result.createGraphics();
        resultGr.setComposite(graphicsComposite);
        resultGr.drawImage((Image)opaque, 0, 0, null);
        resultGr.dispose();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateBackground(Graphics g, AbstractButton button, SubstanceConstants.Side side) {
        Graphics2D graphics = (Graphics2D)g.create();
        SubstanceGradientPainter painter = SubstanceCoreUtilities.getGradientPainter(button);
        int width = button.getWidth();
        int height = button.getHeight();
        try {
            int y = 0;
            ComponentState state = ComponentState.getState(button.getModel(), button);
            painter = new SimplisticSoftBorderReverseGradientPainter();
            ComponentState.ColorSchemeKind kind = state.getColorSchemeKind();
            BufferedImage bgImage = PairwiseButtonBackgroundDelegate.getPairwiseBackground(button, kind, painter, width, height, side, false);
            graphics.drawImage((Image)bgImage, 0, y, null);
            return;
        }
        finally {
            graphics.dispose();
        }
    }

    public static class ButtonBackground {
        public boolean isPaintedActive;
        public BufferedImage backgroundImage;

        public ButtonBackground(boolean isPaintedActive, BufferedImage backgroundImage) {
            this.isPaintedActive = isPaintedActive;
            this.backgroundImage = backgroundImage;
        }
    }
}

