/*
 * Decompiled with CFR 0.152.
 */
package criteres;

import criteres.Critere;
import criteres.CritereCompose;
import criteres.Info;
import criteres.Paire;
import criteres.Singleton;
import don.DonneeID;
import ihm.IHM;

public class CritereRestriction
extends CritereCompose {
    public CritereRestriction() {
    }

    public CritereRestriction(Critere critere1, Critere critere2) {
        super(critere1, critere2);
    }

    public Info evaluer(DonneeID obj) {
        Info val1 = this.m_critere1.evaluer(obj);
        if (this.m_critere2 != null) {
            Info val2 = this.m_critere2.evaluer(obj);
            if (val1.isError() || val2.isError()) {
                return new Singleton(Integer.MAX_VALUE);
            }
            return new Paire(val1, val2);
        }
        return val1;
    }

    public String semantique() {
        return "(" + this.m_critere1.semantique() + " " + IHM.getXmlLangue().getElement("et") + " " + this.m_critere2.semantique() + ")";
    }

    public String semantique(Paire i) {
        String chaineB;
        String chaineA;
        if (i.getD().isError()) {
            return this.m_critere1.semantique(i.getG());
        }
        if (i.getG().isError()) {
            return this.m_critere2.semantique(i.getD());
        }
        if (IHM.getXmlLangue().adjectifsAvant()) {
            if (this.m_critere1.adjectif()) {
                chaineA = this.m_critere1.semantique(i.getG());
                chaineB = this.m_critere2.semantique(i.getD());
            } else {
                chaineA = this.m_critere2.semantique(i.getD());
                chaineB = this.m_critere1.semantique(i.getG());
            }
        } else if (!this.m_critere1.adjectif()) {
            chaineA = this.m_critere1.semantique(i.getG());
            chaineB = this.m_critere2.semantique(i.getD());
        } else {
            chaineA = this.m_critere2.semantique(i.getD());
            chaineB = this.m_critere1.semantique(i.getG());
        }
        if (!chaineB.equals("")) {
            return String.valueOf(chaineA) + " " + chaineB;
        }
        return chaineA;
    }
}

