/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import don.Continue;
import don.Contribution;
import don.Variable;
import ihm.Gestionnaire;
import ihm.Habilleur;
import ihm.IHM;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PanelHabillage
extends JPanel {
    protected Gestionnaire m_gestionnaire;
    protected Habilleur m_habilleur;
    private static final long serialVersionUID = 1L;
    protected JPanel jPanelDiscret = null;
    protected JPanel jPanelContinu = null;
    protected JCheckBox jCheckBoxContinu = null;
    private JPanel jPanelStyle = null;
    private JLabel jLabelStyle = null;
    private JRadioButton jRadioButtonNuage = null;
    private JRadioButton jRadioButtonBulle = null;
    protected JPanel jPanelType = null;
    protected JRadioButton jRadioButtonCos2 = null;
    protected JRadioButton jRadioButtonContrib = null;
    protected ButtonGroup radioButtonGroupTypes = null;
    protected ButtonGroup radioButtonGroupStyles = null;

    protected static void setComboBox(Variable habillage, List<? extends Variable> liste, JComboBox jComboBox) {
        for (Variable variable : liste) {
            jComboBox.addItem(variable);
            if (habillage == null || !habillage.equals(variable)) continue;
            jComboBox.setSelectedItem(variable);
        }
    }

    public PanelHabillage(Gestionnaire gestionnaire) {
        this.m_gestionnaire = gestionnaire;
        this.m_habilleur = this.m_gestionnaire.getHabilleur();
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        if (this.m_habilleur.isHabillageNominalePossible()) {
            this.ajouterJPanelDiscret(gridBagConstraints);
        }
        this.ajouterJPanelContinu(gridBagConstraints);
    }

    protected void ajouterJPanelContinu(GridBagConstraints gridBagConstraints) {
        this.add((Component)this.getJPanelContinu(), gridBagConstraints);
    }

    protected void ajouterJPanelDiscret(GridBagConstraints gridBagConstraints) {
        this.add((Component)this.getJPanelDiscret(), gridBagConstraints);
    }

    protected abstract JPanel getJPanelDiscret();

    protected JPanel getJPanelContinu() {
        if (this.jPanelContinu == null) {
            this.jPanelContinu = new JPanel();
            this.jPanelContinu.setLayout(new BorderLayout());
            this.jPanelContinu.add((Component)this.getJCheckBoxContinu(), "North");
            this.jPanelContinu.add((Component)this.getJPanelStyle(), "East");
            this.jPanelContinu.add((Component)this.getJPanelType(), "Center");
            this.setEnabledPanelContinu(this.jCheckBoxContinu.isSelected());
        }
        return this.jPanelContinu;
    }

    private JCheckBox getJCheckBoxContinu() {
        if (this.jCheckBoxContinu == null) {
            this.jCheckBoxContinu = new JCheckBox(String.valueOf(IHM.getXmlLangue().getElement("MhabCont")) + " : ");
            this.jCheckBoxContinu.addActionListener(this.getListener());
            this.jCheckBoxContinu.setSelected(this.m_habilleur.getHabillageContinu(this.getType()) != null);
        }
        return this.jCheckBoxContinu;
    }

    protected abstract ActionListener getListener();

    private JPanel getJPanelStyle() {
        if (this.jPanelStyle == null) {
            this.radioButtonGroupStyles = new ButtonGroup();
            GridBagConstraints gridBagConstraintsBulle = new GridBagConstraints();
            gridBagConstraintsBulle.gridx = 0;
            gridBagConstraintsBulle.gridy = 2;
            gridBagConstraintsBulle.anchor = 17;
            GridBagConstraints gridBagConstraintsNuage = new GridBagConstraints();
            gridBagConstraintsNuage.gridx = 0;
            gridBagConstraintsNuage.gridy = 1;
            gridBagConstraintsNuage.anchor = 17;
            GridBagConstraints gridBagConstraintsLabel = new GridBagConstraints();
            gridBagConstraintsLabel.anchor = 17;
            this.jLabelStyle = new JLabel();
            this.jLabelStyle.setText(String.valueOf(IHM.getXmlLangue().getElement("MhabStyle")) + " :");
            this.jPanelStyle = new JPanel();
            this.jPanelStyle.setLayout(new GridBagLayout());
            this.jPanelStyle.add((Component)this.jLabelStyle, gridBagConstraintsLabel);
            this.jPanelStyle.add((Component)this.getJRadioButtonNuage(), gridBagConstraintsNuage);
            this.jPanelStyle.add((Component)this.getJRadioButtonBulle(), gridBagConstraintsBulle);
        }
        return this.jPanelStyle;
    }

    private JRadioButton getJRadioButtonNuage() {
        if (this.jRadioButtonNuage == null) {
            this.jRadioButtonNuage = new JRadioButton(IHM.getXmlLangue().getElement("MhabNuage"));
            this.radioButtonGroupStyles.add(this.jRadioButtonNuage);
            this.jRadioButtonNuage.setSelected(true);
        }
        return this.jRadioButtonNuage;
    }

    private JRadioButton getJRadioButtonBulle() {
        if (this.jRadioButtonBulle == null) {
            this.jRadioButtonBulle = new JRadioButton(IHM.getXmlLangue().getElement("MhabBulle"));
            this.radioButtonGroupStyles.add(this.jRadioButtonBulle);
            this.jRadioButtonBulle.setSelected(this.m_habilleur.getHabillageStyleContinu(this.getType()) == 0);
        }
        return this.jRadioButtonBulle;
    }

    protected JPanel getJPanelType() {
        if (this.radioButtonGroupTypes == null) {
            this.radioButtonGroupTypes = new ButtonGroup();
        }
        return this.getJPanelTypeImpl();
    }

    protected abstract JPanel getJPanelTypeImpl();

    protected JRadioButton getJRadioButtonCos2() {
        if (this.jRadioButtonCos2 == null) {
            this.jRadioButtonCos2 = new JRadioButton(IHM.getXmlLangue().getElement("Mcos2Habillage"));
            this.radioButtonGroupTypes.add(this.jRadioButtonCos2);
            this.jRadioButtonCos2.setSelected(true);
        }
        return this.jRadioButtonCos2;
    }

    protected JRadioButton getJRadioButtonContrib() {
        if (this.jRadioButtonContrib == null) {
            this.jRadioButtonContrib = new JRadioButton(IHM.getXmlLangue().getElement("McontribHabillage"));
            this.radioButtonGroupTypes.add(this.jRadioButtonContrib);
            this.jRadioButtonContrib.setSelected(this.m_habilleur.getHabillageContinu(this.getType()) instanceof Contribution);
        }
        return this.jRadioButtonContrib;
    }

    protected void setEnabledPanelContinu(boolean b) {
        this.setEnabledPanelStyle(b);
        if (this.jRadioButtonContrib != null) {
            this.jRadioButtonContrib.setEnabled(b);
        }
        if (this.jRadioButtonCos2 != null) {
            this.jRadioButtonCos2.setEnabled(b);
        }
    }

    protected void setEnabledPanelStyle(boolean b) {
        this.jRadioButtonBulle.setEnabled(b);
        this.jRadioButtonNuage.setEnabled(b);
    }

    public abstract Variable getHabillageDiscret();

    public abstract int getType();

    public abstract Continue getHabillageContinu();

    public int getStyleHabillageContinu() {
        if (this.jRadioButtonBulle == null || this.jRadioButtonNuage == null) {
            return -1;
        }
        if (this.jRadioButtonBulle.isSelected()) {
            return 0;
        }
        if (this.jRadioButtonNuage.isSelected()) {
            return 1;
        }
        return -1;
    }
}

