/*
 * Decompiled with CFR 0.152.
 */
package ihm;

import don.AxePartiel;
import don.ContinueAnalysee;
import don.ContinueMoyenne;
import don.DonneeID;
import don.DonneeParse;
import don.Groupe;
import don.IndividuMoyen;
import don.Modalite;
import don.Nominale;
import don.NullDonneeParse;
import ihm.Gestionnaire;
import ihm.IHM;
import ihm.RenduDonneeID;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FenetreSelection
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final String indiv = IHM.getXmlLangue().getElement("Lindiv");
    private final String mod = IHM.getXmlLangue().getElement("Lmod");
    private final String var = IHM.getXmlLangue().getElement("Lvar");
    private final String groupe = IHM.getXmlLangue().getElement("Lgroupe");
    private final String axesPart = IHM.getXmlLangue().getElement("CaxePart");
    private JPanel m_contentPane = null;
    private JPanel m_panelListe = null;
    private JPanel m_panelOKAnnuler = null;
    private JLabel m_lblTypes = null;
    private JButton m_btOk = null;
    private JButton m_btAnnuler = null;
    protected JList m_lstPossibles = null;
    protected JList m_lstChoisis = null;
    private JButton m_btPrendre1 = null;
    private JButton m_btPrendreTous = null;
    private JButton m_btEnleverTous = null;
    private JButton m_btEnlever1 = null;
    protected JComboBox m_cmbTypes = null;
    protected Gestionnaire m_gestionnaire;
    private DonneeParse m_donneeParse;

    public FenetreSelection(IHM owner, DonneeParse parse2, Gestionnaire gest) {
        super(owner);
        this.m_gestionnaire = gest;
        this.m_donneeParse = parse2;
        this.initialize();
        this.setResizable(false);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private void initialize() {
        this.setSize(441, 344);
        this.setTitle(IHM.getXmlLangue().getElement("Tselect"));
        this.setContentPane(this.getJContentPane());
        this.fixerListe(this.m_lstChoisis, this.m_gestionnaire.getSelectionnes());
        this.mettreAJourPossibles((String)this.m_cmbTypes.getSelectedItem());
    }

    private JPanel getJContentPane() {
        if (this.m_contentPane == null) {
            this.m_contentPane = new JPanel();
            this.m_contentPane.setLayout(new BorderLayout());
            this.m_contentPane.add((Component)this.getJPanelListes(), "Center");
            this.m_contentPane.add((Component)this.getJPanelOkAnnuler(), "South");
        }
        return this.m_contentPane;
    }

    private JPanel getJPanelListes() {
        if (this.m_panelListe == null) {
            GridBagConstraints gridBagConstraintsCombo = new GridBagConstraints();
            gridBagConstraintsCombo.gridy = 0;
            gridBagConstraintsCombo.insets = new Insets(4, 8, 4, 8);
            gridBagConstraintsCombo.fill = 2;
            gridBagConstraintsCombo.weightx = 1.0;
            gridBagConstraintsCombo.gridwidth = 1;
            gridBagConstraintsCombo.gridheight = 1;
            gridBagConstraintsCombo.gridx = 1;
            GridBagConstraints gridBagConstraintsLabel = new GridBagConstraints();
            gridBagConstraintsLabel.gridx = 0;
            gridBagConstraintsLabel.insets = new Insets(8, 8, 8, 0);
            gridBagConstraintsLabel.weightx = 0.0;
            gridBagConstraintsLabel.gridy = 0;
            GridBagConstraints gridBagConstraintsPanelVideHaut = new GridBagConstraints();
            gridBagConstraintsPanelVideHaut.gridx = 2;
            gridBagConstraintsPanelVideHaut.gridy = 0;
            GridBagConstraints gridBagConstraintsPanelVide1 = new GridBagConstraints();
            gridBagConstraintsPanelVide1.gridx = 2;
            gridBagConstraintsPanelVide1.gridy = 1;
            gridBagConstraintsPanelVide1.weighty = 2.0;
            GridBagConstraints gridBagConstraintsPrendre1 = new GridBagConstraints();
            gridBagConstraintsPrendre1.gridx = 2;
            gridBagConstraintsPrendre1.gridy = 2;
            gridBagConstraintsPrendre1.weighty = 1.0;
            gridBagConstraintsPrendre1.insets = new Insets(0, 8, 0, 8);
            GridBagConstraints gridBagConstraintsPrendreTous = new GridBagConstraints();
            gridBagConstraintsPrendreTous.gridx = 2;
            gridBagConstraintsPrendreTous.gridy = 3;
            gridBagConstraintsPrendreTous.weighty = 1.0;
            gridBagConstraintsPrendreTous.insets = new Insets(0, 8, 0, 8);
            GridBagConstraints gridBagConstraintsPanelVide2 = new GridBagConstraints();
            gridBagConstraintsPanelVide2.gridx = 2;
            gridBagConstraintsPanelVide2.gridy = 4;
            gridBagConstraintsPanelVide2.weighty = 2.5;
            GridBagConstraints gridBagConstraintsEnleverTous = new GridBagConstraints();
            gridBagConstraintsEnleverTous.gridx = 2;
            gridBagConstraintsEnleverTous.gridy = 5;
            gridBagConstraintsEnleverTous.weighty = 1.0;
            gridBagConstraintsEnleverTous.insets = new Insets(0, 8, 0, 8);
            GridBagConstraints gridBagConstraintsEnelever1 = new GridBagConstraints();
            gridBagConstraintsEnelever1.gridx = 2;
            gridBagConstraintsEnelever1.gridy = 6;
            gridBagConstraintsEnelever1.weighty = 1.0;
            gridBagConstraintsEnelever1.insets = new Insets(0, 8, 0, 8);
            GridBagConstraints gridBagConstraintsPanelVide3 = new GridBagConstraints();
            gridBagConstraintsPanelVide3.gridx = 2;
            gridBagConstraintsPanelVide3.gridy = 7;
            gridBagConstraintsPanelVide3.weighty = 2.0;
            GridBagConstraints gridBagConstraintsChoisis = new GridBagConstraints();
            gridBagConstraintsChoisis.fill = 1;
            gridBagConstraintsChoisis.weightx = 3.3;
            gridBagConstraintsChoisis.weighty = 1.0;
            gridBagConstraintsChoisis.gridx = 3;
            gridBagConstraintsChoisis.gridy = 1;
            gridBagConstraintsChoisis.insets = new Insets(8, 8, 8, 8);
            gridBagConstraintsChoisis.gridheight = 7;
            gridBagConstraintsChoisis.gridwidth = 2;
            GridBagConstraints gridBagConstraintsPossibles = new GridBagConstraints();
            gridBagConstraintsPossibles.fill = 1;
            gridBagConstraintsPossibles.weighty = 1.0;
            gridBagConstraintsPossibles.gridheight = 7;
            gridBagConstraintsPossibles.gridwidth = 2;
            gridBagConstraintsPossibles.weightx = 2.0;
            gridBagConstraintsPossibles.insets = new Insets(8, 8, 8, 8);
            gridBagConstraintsPossibles.gridx = 0;
            gridBagConstraintsPossibles.gridy = 1;
            this.m_panelListe = new JPanel();
            this.m_panelListe.setLayout(new GridBagLayout());
            this.m_lblTypes = new JLabel();
            this.m_lblTypes.setText(String.valueOf(IHM.getXmlLangue().getElement("Ltypes")) + " :");
            JScrollPane jsChoisis = new JScrollPane(this.getJListChoisis());
            this.m_panelListe.add((Component)this.m_lblTypes, gridBagConstraintsLabel);
            this.m_panelListe.add((Component)this.getJComboBoxTypes(), gridBagConstraintsCombo);
            this.m_panelListe.add((Component)jsChoisis, gridBagConstraintsChoisis);
            this.m_panelListe.add((Component)this.getJButtonPrendre1(), gridBagConstraintsPrendre1);
            JScrollPane jsPossibles = new JScrollPane(this.getJListPossibles());
            JPanel vide1 = new JPanel();
            this.m_panelListe.add((Component)jsPossibles, gridBagConstraintsPossibles);
            this.m_panelListe.add((Component)vide1, gridBagConstraintsPanelVide1);
            this.m_panelListe.add((Component)this.getJButtonPrendreTous(), gridBagConstraintsPrendreTous);
            JPanel vide2 = new JPanel();
            this.m_panelListe.add((Component)vide2, gridBagConstraintsPanelVide2);
            this.m_panelListe.add((Component)this.getJButtonEnleverTous(), gridBagConstraintsEnleverTous);
            this.m_panelListe.add((Component)this.getJButtonEnlever1(), gridBagConstraintsEnelever1);
            JPanel vide3 = new JPanel();
            this.m_panelListe.add((Component)vide3, gridBagConstraintsPanelVide3);
        }
        return this.m_panelListe;
    }

    private JPanel getJPanelOkAnnuler() {
        if (this.m_panelOKAnnuler == null) {
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.insets = new Insets(8, 0, 8, 0);
            gridBagConstraints1.weightx = 1.0;
            gridBagConstraints1.gridx = 4;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(8, 0, 8, 0);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 5;
            this.m_panelOKAnnuler = new JPanel();
            this.m_panelOKAnnuler.setLayout(new BorderLayout());
            JPanel ssPanelOkAnnuler = new JPanel();
            ssPanelOkAnnuler.add((Component)this.getJButtonOK(), gridBagConstraints1);
            ssPanelOkAnnuler.add((Component)this.getJButtonAnnuler(), gridBagConstraints);
            this.m_panelOKAnnuler.add((Component)ssPanelOkAnnuler, "East");
        }
        return this.m_panelOKAnnuler;
    }

    private JButton getJButtonOK() {
        if (this.m_btOk == null) {
            this.m_btOk = new JButton();
            this.m_btOk.setText(IHM.getXmlLangue().getElement("Lok"));
            this.m_btOk.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ListModel list = FenetreSelection.this.m_lstChoisis.getModel();
                    Vector<DonneeID> collec = new Vector<DonneeID>();
                    int i = 0;
                    while (i < list.getSize()) {
                        collec.add((DonneeID)list.getElementAt(i));
                        ++i;
                    }
                    FenetreSelection.this.m_gestionnaire.rmSelectionnes();
                    FenetreSelection.this.m_gestionnaire.addSelectionnes(collec);
                    FenetreSelection.this.dispose();
                }
            });
        }
        return this.m_btOk;
    }

    private JButton getJButtonAnnuler() {
        if (this.m_btAnnuler == null) {
            this.m_btAnnuler = new JButton();
            this.m_btAnnuler.setText(IHM.getXmlLangue().getElement("Lannuler"));
            this.m_btAnnuler.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FenetreSelection.this.dispose();
                }
            });
        }
        return this.m_btAnnuler;
    }

    private JList getJListPossibles() {
        if (this.m_lstPossibles == null) {
            this.m_lstPossibles = new JList();
            this.m_lstPossibles.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    JList list = (JList)evt.getSource();
                    if (evt.getClickCount() == 2) {
                        int index = list.locationToIndex(evt.getPoint());
                        Object[] elements = new Object[]{FenetreSelection.this.m_lstPossibles.getModel().getElementAt(index)};
                        FenetreSelection.this.ajouterChoisis(elements);
                    }
                }
            });
        }
        this.m_lstPossibles.setCellRenderer(new RenduDonneeID(this.m_gestionnaire));
        return this.m_lstPossibles;
    }

    private JList getJListChoisis() {
        if (this.m_lstChoisis == null) {
            this.m_lstChoisis = new JList();
            this.m_lstChoisis.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent evt) {
                    JList list = (JList)evt.getSource();
                    if (evt.getClickCount() == 2) {
                        int index = list.locationToIndex(evt.getPoint());
                        Object[] elements = new Object[]{FenetreSelection.this.m_lstChoisis.getModel().getElementAt(index)};
                        FenetreSelection.this.enleverChoisis(elements);
                    }
                }
            });
        }
        this.m_lstChoisis.setCellRenderer(new RenduDonneeID(this.m_gestionnaire));
        return this.m_lstChoisis;
    }

    private JButton getJButtonPrendre1() {
        if (this.m_btPrendre1 == null) {
            this.m_btPrendre1 = new JButton();
            this.m_btPrendre1.setText(">");
            this.m_btPrendre1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FenetreSelection.this.ajouterChoisis(FenetreSelection.this.m_lstPossibles.getSelectedValues());
                }
            });
        }
        return this.m_btPrendre1;
    }

    private JButton getJButtonPrendreTous() {
        if (this.m_btPrendreTous == null) {
            this.m_btPrendreTous = new JButton();
            this.m_btPrendreTous.setText(">>");
            this.m_btPrendreTous.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    ListModel listeChoisis = FenetreSelection.this.m_lstChoisis.getModel();
                    ListModel listePossibles = FenetreSelection.this.m_lstPossibles.getModel();
                    TreeSet<Object> vect = new TreeSet<Object>(FenetreSelection.this.getComparateur());
                    int i = 0;
                    while (i < listeChoisis.getSize()) {
                        vect.add(listeChoisis.getElementAt(i));
                        ++i;
                    }
                    i = 0;
                    while (i < listePossibles.getSize()) {
                        vect.add(listePossibles.getElementAt(i));
                        ++i;
                    }
                    FenetreSelection.this.m_lstPossibles.setListData(new Vector());
                    FenetreSelection.this.m_lstChoisis.setListData(vect.toArray());
                }
            });
        }
        return this.m_btPrendreTous;
    }

    private JButton getJButtonEnleverTous() {
        if (this.m_btEnleverTous == null) {
            this.m_btEnleverTous = new JButton();
            this.m_btEnleverTous.setText("<<");
            this.m_btEnleverTous.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    FenetreSelection.this.m_lstChoisis.setListData(new Vector());
                    FenetreSelection.this.mettreAJourPossibles((String)FenetreSelection.this.m_cmbTypes.getSelectedItem());
                }
            });
        }
        return this.m_btEnleverTous;
    }

    private JButton getJButtonEnlever1() {
        if (this.m_btEnlever1 == null) {
            this.m_btEnlever1 = new JButton();
            this.m_btEnlever1.setText("<");
            this.m_btEnlever1.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    FenetreSelection.this.enleverChoisis(FenetreSelection.this.m_lstChoisis.getSelectedValues());
                }
            });
        }
        return this.m_btEnlever1;
    }

    private JComboBox getJComboBoxTypes() {
        if (this.m_cmbTypes == null) {
            Vector<String> tab = new Vector<String>();
            switch (this.m_gestionnaire.getType()) {
                case 0: {
                    if (this.m_donneeParse.isIndActif() || this.m_donneeParse.isIndIllus()) {
                        tab.add(this.indiv);
                    }
                    if (!this.m_donneeParse.isModActif() && !this.m_donneeParse.isModIllus()) break;
                    tab.add(this.mod);
                    break;
                }
                case 1: {
                    if (!this.m_donneeParse.isVarActifNonOrtho() && !this.m_donneeParse.isVarActifOrtho() && !this.m_donneeParse.isVarIllusNonOrtho() && !this.m_donneeParse.isVarIllusOrtho() && !this.m_donneeParse.isVarPart()) break;
                    tab.add(this.var);
                    break;
                }
                case 2: {
                    if (!this.m_donneeParse.isGroupeActif() && !this.m_donneeParse.isGroupeIllus()) break;
                    tab.add(this.groupe);
                    break;
                }
                case 3: {
                    if (!this.m_donneeParse.isAxesPart()) break;
                    tab.add(this.axesPart);
                    break;
                }
                case 4: {
                    if (this.m_donneeParse.isIndActif() || this.m_donneeParse.isIndIllus()) {
                        tab.add(this.indiv);
                    }
                    if (!this.m_donneeParse.isModActif() && !this.m_donneeParse.isModIllus()) break;
                    tab.add(this.mod);
                    break;
                }
            }
            this.m_cmbTypes = new JComboBox<Object>(tab.toArray());
            this.m_cmbTypes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent arg0) {
                    String select = (String)FenetreSelection.this.m_cmbTypes.getSelectedItem();
                    FenetreSelection.this.mettreAJourPossibles(select);
                }
            });
        }
        return this.m_cmbTypes;
    }

    private void mettreAJourPossibles(String type) {
        this.fixerListe(this.m_lstPossibles, this.proposerPossibles(type));
    }

    private Vector<? extends DonneeID> proposerPossibles(String type) {
        if (this.indiv.equals(type)) {
            return this.proposerIndividus();
        }
        if (this.mod.equals(type)) {
            return this.proposerModalites();
        }
        if (this.var.equals(type)) {
            return this.proposerVariables();
        }
        if (this.groupe.equals(type)) {
            return this.proposerGroupes();
        }
        if (this.axesPart.equals(type)) {
            return this.proposerAxesPart();
        }
        return new Vector();
    }

    protected Vector<Groupe> proposerGroupes() {
        Vector<Groupe> vect = this.m_donneeParse.getGroupes();
        Vector<Groupe> res = new Vector<Groupe>();
        for (Groupe groupe : vect) {
            if (this.isChoisi(groupe) || groupe.getNum() == 0 || !groupe.isActive()) continue;
            res.add(groupe);
        }
        return res;
    }

    private boolean isChoisi(DonneeID don) {
        ListModel listeChoisis = this.m_lstChoisis.getModel();
        Vector vectChoisis = new Vector();
        int i = 0;
        while (i < listeChoisis.getSize()) {
            vectChoisis.add(listeChoisis.getElementAt(i));
            ++i;
        }
        return vectChoisis.contains(don);
    }

    protected Vector<ContinueMoyenne> proposerVariables() {
        Vector<ContinueMoyenne> vect = this.m_donneeParse.getVariablesMoyennes();
        Vector<ContinueMoyenne> res = new Vector<ContinueMoyenne>();
        for (ContinueMoyenne var : vect) {
            if (this.isChoisi(var)) continue;
            res.add(var);
        }
        return res;
    }

    protected Vector<ContinueAnalysee> proposerAxesPart() {
        Vector<AxePartiel> vect = this.m_donneeParse.getAxesPartiels();
        Vector<ContinueAnalysee> res = new Vector<ContinueAnalysee>();
        for (ContinueAnalysee continueAnalysee : vect) {
            if (this.isChoisi(continueAnalysee)) continue;
            res.add(continueAnalysee);
        }
        return res;
    }

    protected Vector<DonneeID> proposerModalites() {
        TreeSet<Object> vect = new TreeSet<Object>(this.getComparateur());
        for (Nominale nom : this.m_donneeParse.getNominales()) {
            for (Modalite modalite : nom.getModalites()) {
                if (this.isChoisi(modalite)) continue;
                vect.add(modalite);
            }
        }
        Vector<DonneeID> vect2 = new Vector<DonneeID>();
        vect2.addAll(vect);
        return vect2;
    }

    protected Vector<IndividuMoyen> proposerIndividus() {
        Vector<IndividuMoyen> vect = this.m_donneeParse.getIndividusMoyens();
        Vector<IndividuMoyen> res = new Vector<IndividuMoyen>();
        for (IndividuMoyen ind : vect) {
            if (this.isChoisi(ind)) continue;
            res.add(ind);
        }
        return res;
    }

    protected Comparator<Object> getComparateur() {
        return new Comparator<Object>(){

            @Override
            public int compare(Object arg0, Object arg1) {
                RenduDonneeID r = new RenduDonneeID(FenetreSelection.this.m_gestionnaire);
                String chaine0 = ((RenduDonneeID)r.getListCellRendererComponent((JList)null, arg0, 0, true, false)).getText();
                String chaine1 = ((RenduDonneeID)r.getListCellRendererComponent((JList)null, arg1, 0, true, false)).getText();
                return chaine0.compareTo(chaine1);
            }
        };
    }

    private void fixerListe(JList list, Vector vect) {
        TreeSet<Object> set = new TreeSet<Object>(this.getComparateur());
        set.addAll(vect);
        list.setListData(set.toArray());
    }

    private void enleverChoisis(Object[] element) {
        ListModel listeChoisis = this.m_lstChoisis.getModel();
        ListModel listePossibles = this.m_lstPossibles.getModel();
        Vector vectChoisis = new Vector();
        int i = 0;
        while (i < listeChoisis.getSize()) {
            vectChoisis.add(listeChoisis.getElementAt(i));
            ++i;
        }
        Vector vectPossibles = new Vector();
        int i2 = 0;
        while (i2 < listePossibles.getSize()) {
            vectPossibles.add(listePossibles.getElementAt(i2));
            ++i2;
        }
        Vector enleves = new Vector();
        enleves.addAll(Arrays.asList(element));
        vectChoisis.removeAll(enleves);
        this.fixerListe(this.m_lstChoisis, vectChoisis);
        Vector<? extends DonneeID> vectPossiblesInit = this.proposerPossibles((String)this.m_cmbTypes.getSelectedItem());
        enleves.retainAll(vectPossiblesInit);
        vectPossibles.addAll(enleves);
        this.fixerListe(this.m_lstPossibles, vectPossibles);
    }

    private void ajouterChoisis(Object[] elements) {
        ListModel listeChoisis = this.m_lstChoisis.getModel();
        ListModel listePossibles = this.m_lstPossibles.getModel();
        Vector vectChoisis = new Vector();
        int i = 0;
        while (i < listeChoisis.getSize()) {
            vectChoisis.add(listeChoisis.getElementAt(i));
            ++i;
        }
        Vector vectPossibles = new Vector();
        int i2 = 0;
        while (i2 < listePossibles.getSize()) {
            vectPossibles.add(listePossibles.getElementAt(i2));
            ++i2;
        }
        Vector nouveaux = new Vector();
        nouveaux.addAll(Arrays.asList(elements));
        vectChoisis.addAll(nouveaux);
        this.fixerListe(this.m_lstChoisis, vectChoisis);
        vectPossibles.removeAll(nouveaux);
        this.fixerListe(this.m_lstPossibles, vectPossibles);
    }

    public static void main(String[] args) {
        IHM.m_dir = String.valueOf(new File("").getAbsolutePath()) + "\\";
        IHM ihm = new IHM(new NullDonneeParse());
        ihm.setGoByR(false);
        ihm.getGest().ouvrir("K:/dynGraph/test/130707_MCA_a.ser");
        FenetreSelection fen = new FenetreSelection(ihm, ihm.getDonnee(), ihm.getGest());
        fen.setVisible(true);
    }
}

