/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.jfree.data.xy.XYDataset;

public class VectPiePlot
extends XYPlot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -477525209363105945L;
    private boolean m_pie;

    public VectPiePlot(XYDataset dataset, ValueAxis domainAxis, ValueAxis rangeAxis, boolean pie) {
        super(dataset, domainAxis, rangeAxis, null);
        this.m_pie = pie;
    }

    public void drawPie(Graphics2D g2, Rectangle2D dataArea) {
        g2.setPaint(Color.black);
        int x = (int)this.getDomainAxis().valueToJava2D(-1.0, dataArea, this.getDomainAxisEdge());
        int y = (int)this.getRangeAxis().valueToJava2D(1.0, dataArea, this.getRangeAxisEdge());
        int d = (int)this.getDomainAxis().valueToJava2D(1.0, dataArea, this.getDomainAxisEdge()) - x;
        g2.drawOval(x, y, d, d);
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info) {
        this.draw(g2, area, anchor, parentState, info, 1.0);
    }

    public void draw(Graphics2D g2, Rectangle2D area, Point2D anchor, PlotState parentState, PlotRenderingInfo info, double rapport) {
        ValueAxis horizontalAxis = this.getDomainAxis();
        ValueAxis verticalAxis = this.getRangeAxis();
        if (this.m_pie) {
            verticalAxis.setRange(new Range(-1.1, 1.1), false, false);
            horizontalAxis.setRange(new Range(-1.1, 1.1), false, false);
        }
        super.draw(g2, area, anchor, parentState, info, rapport);
        if (this.m_pie) {
            this.drawPie(g2, this.dataArea);
        }
    }
}

