% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_gbif.R
\name{convert_gbif}
\alias{convert_gbif}
\title{Reformats GBIF data into \code{dynamicSDM} data frame}
\usage{
convert_gbif(gbif.df)
}
\arguments{
\item{gbif.df}{a data frame, the direct output from GBIF occurrence record download.}
}
\value{
Returns data frame correctly formatted for input into \code{dynamicSDM} functions.
}
\description{
Function converts GBIF occurrence records into the format required for \code{dynamicSDM}
functions.
}
\details{
For most \code{dynamicSDM} functions, an occurrence data frame with record co-ordinate
columns labelled "x" and "y" with numeric columns for record "day", "month" and "year" are
required. This function takes the input data frame and returns a reformatted data frame
suitable for direct input into \code{dynamicSDM} functions.
}
\examples{

data(sample_occ_data)
converted <- convert_gbif(sample_occ_data)

}
