% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.ddhazard}
\alias{predict.ddhazard}
\title{Predict Method for ddhazard Object}
\usage{
\method{predict}{ddhazard}(object, new_data, type = c("response",
  "term"), tstart = "start", tstop = "stop", use_parallel, sds = F,
  max_threads, ...)
}
\arguments{
\item{object}{result of a \code{\link{ddhazard}} call.}

\item{new_data}{new data to base predictions on.}

\item{type}{either \code{"response"} for predicted probability of an event or \code{"term"} for predicted terms in the linear predictor.}

\item{tstart}{name of the start time column in \code{new_data}. It must be on the same time scale as the \code{tstart} used in the \code{\link[survival]{Surv}(tstart, tstop, event)} in the \code{formula} passed to \code{\link{ddhazard}}.}

\item{tstop}{same as \code{tstart} for the stop argument.}

\item{use_parallel}{not longer supported.}

\item{sds}{\code{TRUE} if point wise standard deviation should be computed. Convenient if you use functions like \code{\link[splines]{ns}} and you only want one term per term in the right hand site of the \code{formula} used in \code{\link{ddhazard}}.}

\item{max_threads}{not longer supported.}

\item{...}{not used.}
}
\description{
Predict method for \code{\link{ddhazard}}.
}
\details{
The function check if there are columns in \code{new_data} which names match
\code{tstart} and \code{tstop}. If matched, then the bins are found which
the start time to the stop time are in. If \code{tstart} and \code{tstop} are not
matched then all the bins used in the estimation method will be used.
}
\section{Term}{

The result with \code{type = "term"} is a lists of list each having length
equal to \code{nrow(new_data)}. The lists are
\describe{
\item{\code{terms}}{It's elements are matrices where the first dimension is
time and the second dimension is the terms.}
\item{\code{sds}}{similar to \code{terms} for the point-wise confidence
intervals using the smoothed co-variance matrices. Only added if
\code{sds = TRUE}.}
\item{\code{fixed_terms}}{contains the fixed (non-time-varying) effect.}
\item{\code{varcov}}{similar to \code{sds} but differs by containing the whole
covariance matrix for the terms. It is a 3D array where the third dimension is
time. Only added if \code{sds = TRUE}.}
\item{\code{start}}{numeric vector with start time for each time-varying term.}
\item{\code{tstop}}{numeric vector with stop time for each time-varying term.}
}
}

\section{Response}{

The result with \code{type = "response"} is a list with the elements below.
If \code{tstart} and \code{tstop} are matched in columns in \code{new_data},
then the probability will be for having an event between \code{tstart} and \code{tstop}
conditional on no events before \code{tstart}.
\describe{
\item{\code{fits}}{fitted probability of an event.}
\item{\code{istart}}{numeric vector with start time for each element in \code{fits}.}
\item{\code{istop}}{numeric vector with stop time for each element in \code{fits}.}
}
}

\examples{
fit <- ddhazard(
 Surv(time, status == 2) ~ log(bili), pbc, id = pbc$id, max_T = 3600,
 Q_0 = diag(1, 2), Q = diag(1e-4, 2), by = 50,
 control = ddhazard_control(method = "GMA"))
predict(fit, type = "response", new_data =
 data.frame(time = 0, status = 2, bili = 3))
predict(fit, type = "term", new_data =
 data.frame(time = 0, status = 2, bili = 3))

# probability of an event between time 0 and 2000 with bili = 3
predict(fit, type = "response", new_data =
          data.frame(time = 0, status = 2, bili = 3, tstart = 0, tstop = 2000),
        tstart = "tstart", tstop = "tstop")

}
