% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddhazard.R
\name{ddhazard_control}
\alias{ddhazard_control}
\title{Auxiliary for Controlling Dynamic Hazard Models}
\usage{
ddhazard_control(
  kappa = NULL,
  alpha = 1,
  beta = 0,
  NR_eps = NULL,
  LR = 1,
  n_max = 10^2,
  eps = 0.001,
  est_Q_0 = FALSE,
  method = "EKF",
  save_risk_set = TRUE,
  save_data = TRUE,
  eps_fixed_parems = 1e-04,
  fixed_parems_start = NULL,
  n_threads = getOption("ddhazard_max_threads"),
  denom_term = 1e-05,
  fixed_terms_method = "E_step",
  Q_0_term_for_fixed_E_step = NULL,
  permu = if (!is.null(method)) method == "SMA" else FALSE,
  posterior_version = "cholesky",
  GMA_max_rep = 25,
  GMA_NR_eps = 1e-04,
  est_a_0 = TRUE,
  ...
)
}
\arguments{
\item{kappa}{hyper parameter \eqn{\kappa} in the unscented Kalman Filter.}

\item{alpha}{hyper parameter \eqn{\alpha} in the unscented Kalman Filter.}

\item{beta}{hyper parameter \eqn{\beta} in the unscented Kalman Filter.}

\item{NR_eps}{tolerance for the Extended Kalman filter. Default is
\code{NULL} which means that no extra iteration is made in the correction
step.}

\item{LR}{learning rate.}

\item{n_max}{maximum number of iteration in the EM-algorithm.}

\item{eps}{tolerance parameter for the EM-algorithm}

\item{est_Q_0}{\code{TRUE} if you want the EM-algorithm to estimate
\code{Q_0}. Default is \code{FALSE}.}

\item{method}{set to the method to use in the E-step. Either \code{"EKF"}
for the Extended Kalman Filter, \code{"UKF"} for the Unscented Kalman
Filter, \code{"SMA"} for the sequential posterior mode approximation method
or \code{"GMA"} for the global mode approximation method. \code{"EKF"} is
the default.}

\item{save_risk_set}{\code{TRUE} if you want to save the list from
\code{\link{get_risk_obj}} used to estimate the model. It may be needed for
later calls to e.g., \code{residuals}, \code{plot} and \code{logLike}.}

\item{save_data}{\code{TRUE} if you want to keep the \code{data} argument.
It may be needed for later calls to e.g., \code{residuals}, \code{plot} and
\code{logLike}.}

\item{eps_fixed_parems}{tolerance used in the M-step of the Fisher's scoring
algorithm for the fixed effects}

\item{fixed_parems_start}{starting value for fixed terms.}

\item{n_threads}{maximum number of threads to use.}

\item{denom_term}{term added to denominators in either the EKF or UKF.}

\item{fixed_terms_method}{the method used to estimate the fixed effects.
Either \code{'M_step'} or \code{'E_step'} for estimation in the M-step or
E-step respectively.}

\item{Q_0_term_for_fixed_E_step}{the diagonal value of the initial
covariance matrix, \code{Q_0}, for the fixed effects if fixed effects are
estimated in the E-step.}

\item{permu}{\code{TRUE} if the risk sets should be permutated before
computation. This is \code{TRUE} by default for posterior mode approximation
method and \code{FALSE} for all other methods.}

\item{posterior_version}{the implementation version of the posterior
approximation method. Either \code{"woodbury"} or \code{"cholesky"}.}

\item{GMA_max_rep}{maximum number of iterations in the correction step if
\code{method = 'GMA'}.}

\item{GMA_NR_eps}{tolerance for the convergence criteria for the relative
change in the norm of the coefficients in the correction step if
\code{method = 'GMA'}.}

\item{est_a_0}{\code{FALSE} if the starting value of the state model should
be fixed.}

\item{...}{additional undocumented arguments.}
}
\value{
A list with components named as the arguments.
}
\description{
Auxiliary for additional settings with \code{\link{ddhazard}}.
}
\seealso{
\code{\link{ddhazard}}
}
