% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lfo.R
\name{lfo}
\alias{lfo}
\title{Approximate Leave-Future-Out (LFO) Cross-validation}
\usage{
lfo(x, L, verbose = TRUE, k_threshold = 0.7, ...)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{L}{[\code{integer(1)}]\cr Positive integer defining how many time points
should be used for the initial fit.}

\item{verbose}{[\code{logical(1)}]\cr If \code{TRUE} (default), print the progress of
the LFO computations to the console.}

\item{k_threshold}{[\code{numeric(1)}]\cr Threshold for the pareto k estimate
triggering refit. Default is 0.7.}

\item{...}{Additional parameters to \code{dynamite}.}
}
\value{
An \code{lfo} object which is a \code{list} with the following components:
\itemize{
\item \code{ELPD}\cr Expected log predictive density estimate.
\item \code{ELPD_SE}\cr Standard error of ELPD. This is a crude approximation which
does not take into account potential serial correlations.
\item \code{pareto_k}\cr Pareto k values.
\item \code{refits}\cr Time points where model was re-estimated.
\item \code{L}\cr L value used in the LFO estimation.
\item \code{k_threshold}\cr Threshold used in the LFO estimation.
}
}
\description{
Estimates the leave-future-out (LFO) information criterion for \code{dynamite}
models using Pareto smoothed importance sampling.
}
\details{
For multichannel models, the log-likelihoods of all channels are combined.
For models with groups, expected log predictive densities (ELPDs) are
computed independently for each group, but the re-estimation of the model
is triggered if pareto k values of any group exceeds the threshold.
}
\examples{
\donttest{
# this gives warnings due to the small number of iterations
out <- suppressWarnings(lfo(gaussian_example_fit, L = 20))
out$ELPD
out$ELPD_SE
}

}
