% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{get_parameter_names}
\alias{get_parameter_names}
\alias{get_parameter_names.dynamitefit}
\title{Get Parameter Names of the Dynamite Model}
\usage{
get_parameter_names(x, types = NULL, ...)

\method{get_parameter_names}{dynamitefit}(x, types = NULL, ...)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{types}{[\code{character()}]\cr Extract only names of parameter of a
certain type. See \code{\link[=get_parameter_types]{get_parameter_types()}}.}

\item{...}{Ignored.}
}
\value{
A \code{character} vector with parameter names of the input model.
}
\description{
Extracts all parameter names of used in the \code{dynamitefit} object.
}
\details{
The naming of parameters generally follows style where the name starts with
the parameter type (e.g. beta for time-invariant regression coefficient),
followed by underscore and the name of the response variable, and in case of
time-invariant, time-varying or random effect, the name of the predictor. An
exception to this is spline coefficients omega, which also contain the
number denoting the knot number.
}
\examples{
get_parameter_names(multichannel_example_fit)

}
\seealso{
Model outputs
\code{\link{as.data.frame.dynamitefit}()},
\code{\link{as.data.table.dynamitefit}()},
\code{\link{as_draws_df.dynamitefit}()},
\code{\link{coef.dynamitefit}()},
\code{\link{confint.dynamitefit}()},
\code{\link{dynamite}()},
\code{\link{get_code}()},
\code{\link{get_data}()},
\code{\link{get_parameter_dims}()},
\code{\link{get_parameter_types}()},
\code{\link{ndraws.dynamitefit}()},
\code{\link{nobs.dynamitefit}()}
}
\concept{output}
