\name{run.sets}
\alias{run.sets}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Run model against an ensemble of parameter sets
}
\description{
Run the model for a particular project against the parameter values taken from a table (data frame), generated e.g by build.calib.sets 
}
\usage{
run.sets(proj, disc = proj$disc[[1]], calib.set, apply.to = 1:nrow(disc$groups), 
  ichan = disc$ichan, fn = NULL)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{proj}{
A Dynamic TOPMODEL project wrapper
}
  \item{disc}{
The discretisation of the project to apply parameters to and run.
}
  \item{calib.set}{
Calibration set (Latin Hypercube) generated by build.calib.set
}
  \item{apply.to}{
Indicies of HRUs to which to apply values. Other HRU will keep existing values across runs.
}
  \item{ichan}{
Channel identifiers
}
  \item{fn}{
optional output filename for results.
}

}
\details{
The project and discretisation will be run using every set in the input table. If fn is suplied then the results of each run will be appended to that file on completion.
}
\value{
A data frame comprising the results of the multiple runs, including the parameters used, the water balance and efficiency measures. See run.gof for the meaning of these values.

}

\references{
Boyle, D. P., H. V. Gupta, and S. Sorooshian (2000), Toward Improved Calibration of Hydrologic Models: Combining the Strengths of Manual and Automatic Methods, Water Resour. Res., 36(12), 3663-3674 

Gupta, Hoshin V., Harald Kling, Koray K. Yilmaz, Guillermo F. Martinez. Decomposition of the mean squared error and NSE performance criteria: Implications for improving hydrological modelling. Journal of Hydrology, Volume 377, Issues 1-2, 20 October 2009, Pages 80-91. DOI: 10.1016/j.jhydrol.2009.08.003. ISSN 0022-1694 

Criss, R. E. and Winston, W. E. (2008), Do Nash values have value? Discussion and alternate proposals. Hydrological Processes, 22: 2723-2725. doi: 10.1002/hyp.7072

Yilmaz, K. K., H. V. Gupta, and T. Wagener (2008), A process-based diagnostic approach to model evaluation: Application to the NWS distributed hydrologic model, Water Resour. Res., 44, W09417, doi:10.1029/2007WR006716 
}
\author{
Peter Metcalfe <p.metcalfe@lancs.ac.uk>
}
\note{
Efficiency measures are generated using the hydroGOF package by Mauricio Zambrano Bigiarini. For details of the output see the documenatation for that package and references within.
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{build.calib.set}}
\code{\link{run.gof}}
\code{\link{run.proj}}
}
\examples{
 \dontrun{
  require(dynatopmod)
  
  # load the Morland DTC project
  data(mor)
  
  # initial parameter values
  hru <- mor$disc[[1]]$groups
  
  # parameter value ranges
  m <-seq(0.005, 0.01, by=0.001)
  ln_t0<-seq(11, 12, by=0.1)
  
  # explicit values for less sensitive parameters
  td <- c(0.5, 1, 10)
  vchan <- seq(1500, 5500, by=1000)
  
  # build a calibration set
  calib.set <- build.calib.set(groups=hru, 
                             list(td=td, vchan=vchan, ln_t0=ln_t0, m=m))

  cat("No. calibration sets = ", nrow(calib.set), "\n")

  res <- run.sets(mor, calib.set=calib.set)
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ ~calibration }
\keyword{ ~TOPMODEL }% __ONLY ONE__ keyword per line
