% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataDoc.R
\docType{data}
\name{Oscillator}
\alias{Oscillator}
\title{Simulated time series data of a damped linear oscillator}
\format{A data frame with 1000 rows and 5 variables}
\usage{
data(Oscillator)
}
\description{
A dataset simulated using a damped linear oscillator model in continuous time
with 1 observed indicator for identifying two latent factors (position and velocity).
The variables are as follows:
}
\details{
\itemize{
  \item id. ID of the systems (1 to 1 because this is a single person)
  \item y1. Noisy observed position
  \item times. Time index (1000 time points) spaced at one unit intervals
  \item x1. True latent position
  \item x2. True latent velocity
}
}
\examples{
# The following was used to generate the data
#--------------------------------------
# Data Generation
\dontrun{
require(mvtnorm)
require(Matrix)

xdim <- 2
udim <- 1
ydim <- 1
tdim <- 1000
set.seed(315)
tA <- matrix(c(0, -.3, 1, -.7), xdim, xdim)
tB <- matrix(c(0), xdim, udim)
tC <- matrix(c(1, 0), ydim, xdim)
tD <- matrix(c(0), ydim, udim)
tQ <- matrix(c(0), xdim, xdim); diag(tQ) <- c(0, 2.2)
tR <- matrix(c(0), ydim, ydim); diag(tR) <- c(1.5)

x0 <- matrix(c(0, 1), xdim, 1)
P0 <- diag(c(1), xdim)
tdx <- matrix(0, xdim, tdim+1)
tx <- matrix(0, xdim, tdim+1)
tu <- matrix(0, udim, tdim)
ty <- matrix(0, ydim, tdim)

tT <- matrix(0:tdim, nrow=1, ncol=tdim+1)

tI <- diag(1, nrow=xdim)

tx[,1] <- x0
for(i in 2:(tdim+1)){
	q <- t(rmvnorm(1, rep(0, xdim), tQ))
	tdx[,i] <- tA \%*\% tx[,i-1] + tB \%*\% tu[,i-1] + q
	expA <- as.matrix(expm(tA * (tT[,i]-tT[,i-1])))
	intA <- solve(tA) \%*\% (expA - tI)
	tx[,i] <- expA \%*\% tx[, i-1] + intA \%*\% tB \%*\% tu[,i-1] + intA \%*\% q
	ty[,i-1] <- tC \%*\% tx[,i] + tD \%*\% tu[,i-1] + t(rmvnorm(1, rep(0, ydim), tR))
}



rownames(ty) <- paste('y', 1:ydim, sep='')
rownames(tx) <- paste('x', 1:xdim, sep='')
simdata <- cbind(id=rep(1, tdim), t(ty), times=tT[,-1], t(tx)[-1,])
 write.table(simdata, file='Oscillator.txt', row.names=FALSE, col.names=TRUE)

plot(tx[1,], type='l')
plot(tT[,-1], ty[1,], type='l')
}
}
\keyword{datasets}

