% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.formulaDynamics}
\alias{prep.formulaDynamics}
\title{Recipe function for specifying dynamic functions using formulas}
\usage{
prep.formulaDynamics(formula, startval, isContinuousTime = FALSE, jacobian)
}
\arguments{
\item{formula}{a list of formulas specifying the drift or state-transition
equations for the latent variables in continuous or discrete time, respectively.}

\item{startval}{a named vector of starting values of the parameters in the
formulas for estimation with parameter names as its name.}

\item{isContinuousTime}{if True, the left hand side of the formulas represent
the first-order derivatives of the specified variables; if False, the left hand
side of the formulas represent the current state of the specified variable while
the same variable on the righ hand side is its previous state.}

\item{jacobian}{(optional) a list of formulas specifying the analytic jacobian matrices
containing the analytic differentiation function of the dynamic functions with respect to
the latent variables. If this is not provided, dynr will invoke an automatic differentiation
procedure to compute the jacobian functions.}
}
\description{
Recipe function for specifying dynamic functions using formulas
}
\examples{
#Not run:
#For a full demo example that uses user-supplied analytic jacobian functions see:
#demo(RSNonlinearDiscrete, package="dynr")
formula=list(list(x1~a1*x1,x2~a2*x2),list(x1~a1*x1+c12*(exp(abs(x2)))/(1+exp(abs(x2)))*x2,
    x2~a2*x2+c21*(exp(abs(x1)))/(1+exp(abs(x1)))*x1))
jacob=list(
  list(x1~x1~a1,
      x2~x2~a2),
  list(x1~x1~a1,
      x1~x2~c12*(exp(abs(x2))/(exp(abs(x2))+1)+x2*sign(x2)*exp(abs(x2))/(1+exp(abs(x2))^2)),
      x2~x2~a2,
      x2~x1~c21*(exp(abs(x1))/(exp(abs(x1))+1)+x1*sign(x1)*exp(abs(x1))/(1+exp(abs(x1))^2))))
dynm<-prep.formulaDynamics(formula=formula,startval=c(a1=.3,a2=.4,c12=-.5,c21=-.5),
isContinuousTime=FALSE,jacobian=jacob)

#For a full demo example that uses automatic jacobian functions see:
#demo(RSNonlinearODE , package="dynr")
formula=list(prey~ a*prey - b*prey*predator, predator~ -c*predator + d*prey*predator)
dynm<-prep.formulaDynamics(formula=formula,
                          startval=c(a = 2.1, c = 0.8, b = 1.9, d = 1.1),
                          isContinuousTime=TRUE)
}

