% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynrRecipe.R
\name{prep.regimes}
\alias{prep.regimes}
\title{Recipe function for creating regime switching (Markov transition) functions}
\usage{
prep.regimes(values, params, covariates)
}
\arguments{
\item{values}{matrix giving the values. Should have (number of Regimes) rows 
and (number of regimes x number of covariates) columns}

\item{params}{matrix of the same size as "values" consisting of the names of the parameters}

\item{covariates}{a vector of the names of the covariates to be used in the regime-switching functions}
}
\description{
Recipe function for creating regime switching (Markov transition) functions
}
\details{
Note that each row of the transition probability matrix must sum to one. To accomplish this
fix at least one transition log odds parameter in each row of "values" (including its intercept 
and the regression slopes of all covariates) to 0.
}
\examples{
#Regime-switching with no covariates (self-transition ID)
b <- prep.regimes(values=matrix(0, 3, 3), 
params=matrix(c(0, 'p1', 'p2', 'p3', 0, 'p4', 'p5', 'p6', 0), 3, 3))

#Regime switching with no covariates (second regime ID)
b <- prep.regimes(values=matrix(0, 3, 3), 
params=matrix(c('p1', 'p2', 'p3', 0, 0, 0, 'p4', 'p5', 'p6'), 3, 3))

#2 regimes with three covariates
b <- prep.regimes(values=matrix(c(0), 2, 8), 
params=matrix(c(paste0('p', 8:15), rep(0, 8)), 2, 8), 
covariates=c('x1', 'x2', 'x3'))
}

