% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrap_add_trajectory.R
\name{add_trajectory}
\alias{add_trajectory}
\alias{is_wrapper_with_trajectory}
\title{Construct a trajectory given its milestone network and milestone percentages or progressions}
\usage{
add_trajectory(dataset, milestone_ids = NULL, milestone_network,
  divergence_regions = NULL, milestone_percentages = NULL,
  progressions = NULL, allow_self_loops = FALSE, ...)

is_wrapper_with_trajectory(trajectory)
}
\arguments{
\item{dataset}{A dataset created by \code{\link[=wrap_data]{wrap_data()}} or \code{\link[=wrap_expression]{wrap_expression()}}}

\item{milestone_ids}{The ids of the milestones in the trajectory. Type: Character vector.}

\item{milestone_network}{The network of the milestones.
Type: Data frame(from = character, to = character, length = numeric, directed = logical).}

\item{divergence_regions}{A data frame specifying the divergence
regions between milestones (e.g. a bifurcation).
Type: Data frame(divergence_id = character, milestone_id = character, is_start = logical).}

\item{milestone_percentages}{A data frame specifying what percentage milestone each cell
consists of.
Type: Data frame(cell_id = character, milestone_id = character, percentage = numeric).}

\item{progressions}{Specifies the progression of a cell along a transition in the milestone_network.
Type: Data frame(cell_id = character, from = character, to = character, percentage = numeric).}

\item{allow_self_loops}{Whether to allow self loops
Type: Logical}

\item{...}{extra information to be stored in the dataset}

\item{trajectory}{The trajectory as created by \code{\link[=infer_trajectory]{infer_trajectory()}} or \code{\link[=add_trajectory]{add_trajectory()}}}
}
\value{
The dataset object with trajectory information, including:
\itemize{
\item \emph{milestone_ids}: The names of the milestones, a character vector.
\item \emph{milestone_network}: The network between the milestones, a dataframe with the \emph{from} milestone, \emph{to} milestone, \emph{length} of the edge, and whether it is \emph{directed}.
\item \emph{divergence_regions}: The regions between three or more milestones where cells are diverging, a dataframe with the divergence id (\emph{divergence_id}), the milestone id (\emph{milestone_id}) and whether this milestone is the start of the divergence (\emph{is_start})
\item \emph{milestone_percentages}: For each cell its closeness to a particular milestone, a dataframe with the cell id (\emph{cell_id}), the milestone id (\emph{milestone_id}), and its \emph{percentage} (a number between 0 and 1 where higher values indicate that a cell is close to the milestone).
\item \emph{progressions}: For each cell its progression along a particular edge of the \emph{milestone_network}. Contains the same information as \emph{milestone_percentages}. A dataframe with cell id (\emph{cell_id}), \emph{from} milestone, \emph{to} milestone, and its \emph{percentage} (a number between 0 and 1 where higher values indicate that a cell is close to the \emph{to} milestone and far from the \emph{from} milestone).
}
}
\description{
Construct a trajectory given its milestone network and milestone percentages or progressions
}
\examples{
library(dplyr)
library(tibble)

dataset <- wrap_data(cell_ids = letters)

milestone_network <- tribble(
  ~from, ~to, ~length, ~directed,
  "A", "B", 1, FALSE,
  "B", "C", 2, FALSE,
  "B", "D", 1, FALSE,
)
milestone_network
progressions <- milestone_network \%>\%
  sample_n(length(dataset$cell_ids), replace = TRUE, weight = length) \%>\%
  mutate(
    cell_id = dataset$cell_ids,
    percentage = runif(n())
  ) \%>\%
  select(cell_id, from, to, percentage)
progressions
divergence_regions <- tribble(
  ~divergence_id, ~milestone_id, ~is_start,
  "1", "A", TRUE,
  "1", "B", FALSE,
  "1", "C", FALSE
)
divergence_regions

trajectory <- add_trajectory(
  dataset,
  milestone_network = milestone_network,
  divergence_regions = divergence_regions,
  progressions = progressions
)

# for plotting the result, install dynplot
#- dynplot::plot_graph(trajectory)
}
\keyword{create_trajectory}
