% Generated by roxygen2: do not edit by hand
% Please edit documentation in
%   R/convert_milestone_percentages_to_progressions.R,
%   R/convert_progressions_to_milestone_percentages.R
\name{convert_milestone_percentages_to_progressions}
\alias{convert_milestone_percentages_to_progressions}
\alias{convert_progressions_to_milestone_percentages}
\title{Conversion between milestone percentages and progressions}
\usage{
convert_milestone_percentages_to_progressions(
  cell_ids,
  milestone_ids,
  milestone_network,
  milestone_percentages
)

convert_progressions_to_milestone_percentages(
  cell_ids,
  milestone_ids,
  milestone_network,
  progressions
)
}
\arguments{
\item{cell_ids}{The identifiers of the cells.}

\item{milestone_ids}{The ids of the milestones in the trajectory. Type: Character vector.}

\item{milestone_network}{The network of the milestones.
Type: Data frame(from = character, to = character, length = numeric, directed = logical).}

\item{milestone_percentages}{A data frame specifying what percentage milestone each cell
consists of.
Type: Data frame(cell_id = character, milestone_id = character, percentage = numeric).}

\item{progressions}{Specifies the progression of a cell along a transition in the milestone_network.
Type: Data frame(cell_id = character, from = character, to = character, percentage = numeric).}
}
\value{
For \code{convert_milestone_percentages_to_progressions}: The progressions
For \code{convert_progressions_to_milestone_percentages}: The milestone percentages
}
\description{
Conversion between milestone percentages and progressions
}
\examples{
progressions <- convert_milestone_percentages_to_progressions(
  cell_ids = example_trajectory$cell_ids,
  milestone_ids = example_trajectory$milestone_ids,
  milestone_network = example_trajectory$milestone_network,
  milestone_percentages = example_trajectory$milestone_percentages
)
head(progressions)

milestone_percentages <- convert_progressions_to_milestone_percentages(
  cell_ids = example_trajectory$cell_ids,
  milestone_ids = example_trajectory$milestone_ids,
  milestone_network = example_trajectory$milestone_network,
  progressions = example_trajectory$progressions
)
head(milestone_percentages)

}
\seealso{
\code{\link[=add_trajectory]{add_trajectory()}}
}
