% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fnc_steyx.R
\name{steyx}
\alias{steyx}
\title{Implementation of the STEYX function from Excel.}
\usage{
steyx(x, y)
}
\arguments{
\item{x}{x values as numeric vector.}

\item{y}{y values as numeric vector of similar length as x.}
}
\value{
The standard error of the predicted y-value for each x in the regression.
}
\description{
Translation of \code{STEYX} function from Excel to R. It is implemented
according to the formula described in
\url{http://office.microsoft.com/en-au/excel-help/steyx-function-HP010062545.aspx}.
At least 3 finite pairs of data points are required for the calculation.
}
\examples{
steyx(x = 1:3, y = 2:4)
steyx(x = 1:3, y = c(2, 3.1, 3.9))
}
