% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallel3D.R
\name{parpbapply}
\alias{parpbapply}
\title{Parallel apply with progressbar}
\usage{
parpbapply(
  X,
  FUN,
  MARGIN,
  packages = NULL,
  export = NULL,
  envir = environment(),
  nNodes = parallel::detectCores() - 1
)
}
\arguments{
\item{X}{an array, including a matrix.}

\item{FUN}{function, the function to be applied to each element of X}

\item{MARGIN}{a vector giving the subscripts which the function will be applied over. E.g., for a matrix 1 indicates rows, 2 indicates columns, c(1, 2) indicates rows and columns. Where X has named dimnames, it can be a character vector selecting dimension names.}

\item{packages}{character vector, Only relevant for Windows: the packages needed in the function provided, eg. c("MASS", "data.table")}

\item{export}{character vector, Only relevant for Windows: the varibales needed in the function provided, eg. c("df", "vec")}

\item{envir}{environment, Only relevant for Windows: Environment from which the variables should be exported from}

\item{nNodes}{numeric, Number of processes to start (unix: best to fit with the available Cores)}
}
\value{
Returns a vector or array or list of values obtained by applying a function to margins of an array or matrix.
}
\description{
Function detects the operating system and chooses the approximate kind of process for parallelizing the task:
Windows: PSOCKCluster, Unix: Forking.
}
\examples{
n <- 1000
df <- data.frame(
x = seq(1, n, 1),
y = -seq(1, n, 1)
)
a <- parpbapply(X = df, FUN = sum, MARGIN = 1, nNodes = 2)
}
