% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_abundance.R
\name{model_abundance}
\alias{model_abundance}
\title{Calculate predicted abundance}
\usage{
model_abundance(x, dens.idx, sum.abund = TRUE)
}
\arguments{
\item{x}{object of class \code{sf}; SDM with density predictions.
Must have a valid crs code}

\item{dens.idx}{name or index of column(s) in \code{x} with density predictions.
Can be a character vector (column names) or numeric vector (column indices)}

\item{sum.abund}{logical; whether or not to sum all of the predicted abundances}
}
\value{
If \code{sum.abund == TRUE}, then a vector of the same length as \code{dens.idx}
  representing the predicted abundance for the density values in each column.

  If \code{sum.abund == FALSE} and the length of \code{dens.idx} is 1,
  then a numeric vector with the predicted abundance of each prediction polygon of \code{x}.

  If \code{sum.abund == FALSE} and the length of \code{dens.idx} is greater than 1,
  then a data frame with \code{length(dens.idx)} columns of the predicted abundance of prediction polygons
}
\description{
Calculates the predicted abundance by multiplying the density prediction values by prediction polygon areas
}
\details{
Multiplies the values in the specified column(s) (i.e. the density predictions)
  by the area in square kilometers of their corresponding prediction polygon.
  The area of each prediction polygon is calculated using \code{st_area} from \code{\link[sf]{geos_measures}}.
  x must have a valid crs code to calculate area for these abundance calculations.
}
\examples{
model_abundance(preds.1, "Density")
model_abundance(preds.1, c(1, 1))
model_abundance(preds.1, c(1, 1), FALSE)

}
