% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_palettes.R
\name{getDiscreteColors}
\alias{getDiscreteColors}
\alias{setColor}
\title{Generate palettes of distinct colors}
\usage{
getDiscreteColors(
  n,
  pal = NULL,
  is.extend = TRUE,
  random = c("no", "randomColor", "distinctColorPalette", "Polychrome"),
  seed = 1234,
  verbose = FALSE,
  ...
)

setColor(x, pal = NULL, ...)
}
\arguments{
\item{n}{How many colors do we need?}

\item{pal}{Name of the palette to use. Use \code{names(pal_discrete)} to get
all palette names}

\item{is.extend}{When \code{n > length(pal_discrete[[pal]])},
whether or not to extend the colors with
\code{\link[grDevices:colorRamp]{colorRampPalette}}.}

\item{random}{Choose a method to generate random colors. Default is "no".}

\item{seed}{Seed for random colors.}

\item{verbose}{Show progress messages.}

\item{...}{Extra parameters passed to other functions depending on 
\code{random}:
\itemize{
\item \code{randomColor()} or \code{distinctColorPalette()}. This requires 
manual installation of \pkg{randomcoloR}
\item \code{\link[Polychrome]{createPalette}} from \pkg{Polychrome}
}}

\item{x}{A factor to use colors.}
}
\value{
A vector with \code{n} colors. For \code{setColor}, also set names as
factor levels.
}
\description{
Generate palettes of distinct colors
}
\examples{
getDiscreteColors(10)
getDiscreteColors(
  10, 
  random = "Polychrome", 
  seedcolors = scales::hue_pal()(4)
)

}
