% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation-matrix_dimensions.R
\name{validation-matrix_dimensions}
\alias{validation-matrix_dimensions}
\alias{validMatDims}
\alias{validMatDimnames}
\title{Validation functions for the dimensions of matrix-like objects}
\usage{
validMatDims(mat, nrow = NULL, ncol = NULL)

validMatDimnames(
  mat,
  row.names = NULL,
  col.names = NULL,
  dup.rownames = FALSE,
  dup.colnames = FALSE
)
}
\arguments{
\item{mat}{A matrix-like object}

\item{nrow}{Expect how many rows in `mat`.}

\item{ncol}{Expect how many columns in `mat`.}

\item{row.names}{Expected row names for `mat`.}

\item{col.names}{Expected column names for `mat`.}

\item{dup.rownames, dup.colnames}{Whether or not to allow duplicated dimension
names in `mat`.}
}
\value{
If all the validations are passed, return invisible `NULL`.
}
\description{
Functions to check whether a matrix-like object has expected dimension
numbers or names.
}
\examples{
mat1 <- matrix(0, 3, 5)
validMatDims(mat1, 3, 5)

## Check dimnames
mat1 <- matrix(0, 3, 5)
rownames(mat1) <- letters[1:3]
colnames(mat1) <- LETTERS[1:5]
try(validMatDimnames(mat1, row.names = letters[2:4]))  ## Error
rownames(mat1) <- c("A", "B", "A")
try(validMatDimnames(mat1, row.names = letters[2:4]))  ## Error

}
