% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3rename_fam_vars.R
\name{rename_fam_vars}
\alias{rename_fam_vars}
\title{Rename longitudinal Family File variables}
\usage{
rename_fam_vars(in_direc, out_direc)
}
\arguments{
\item{in_direc}{Directory of PSID .rds files to rename}

\item{out_direc}{Directory for renamed PSID .rds files to be saves to. Warning: If no directory specified, this function will overwrite the Family Files in the current directory.}
}
\description{
Renames all longitudinal variables in every PSID Family File of a given directory, such that variables are labeled with the variable name used when the variable was first made available in the PSID. For example, the "Release Number" variable was first recorded in the PSID dataset in 1968 as variable "V1" but its name in the 1969 family file is "V441". This program changes the "Release Number" variable name to "V1" in 1968 and all subsequent waves.
}
\examples{
rename_fam_vars(
    in_direc=system.file("extdata","rds_dir", package = "easyPSID"),
    out_direc=tempdir()
)
}
\keyword{PSID}
