% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/easylabel.R
\name{easylabel}
\alias{easylabel}
\title{Interactive scatter plot labels}
\usage{
easylabel(
  data,
  x,
  y,
  labs = NULL,
  startLabels = NULL,
  start_xy = NULL,
  cex.text = 0.72,
  col = NULL,
  colScheme = NULL,
  alpha = 1,
  shape = NULL,
  shapeScheme = 21,
  size = 8,
  sizeRange = c(4, 80),
  xlab = x,
  ylab = y,
  xlim = NULL,
  ylim = NULL,
  xticks = NULL,
  yticks = NULL,
  showOutliers = TRUE,
  outlier_shape = 5,
  outline_col = "white",
  outline_lwd = 0.5,
  plotly_filter = NULL,
  width = 800,
  height = 600,
  showgrid = FALSE,
  zeroline = TRUE,
  hline = NULL,
  vline = NULL,
  mgp = c(1.8, 0.5, 0),
  Ltitle = "",
  Rtitle = "",
  LRtitle_side = 1,
  labelDir = "radial",
  labCentre = NULL,
  lineLength = 75,
  text_col = "black",
  line_col = "black",
  rectangles = FALSE,
  rect_col = "white",
  border_col = "black",
  padding = 3,
  border_radius = 5,
  showLegend = TRUE,
  legendxy = c(1.02, 1),
  filename = NULL,
  panel.last = NULL,
  fullGeneNames = FALSE,
  AnnotationDb = NULL,
  custom_annotation = NULL,
  output_shiny = TRUE,
  ...
)
}
\arguments{
\item{data}{Dataset (data.frame or data.table) to use for plot.}

\item{x}{Specifies column of x coordinates in \code{data}.}

\item{y}{Specifies column of y coordinates in \code{data}.}

\item{labs}{Specifies the column in \code{data} with label names for points.
Label names do not have to be unique. If \code{NULL} defaults to \code{rownames(data)}.}

\item{startLabels}{Vector of initial labels. With a character vector, labels
are identified in the column specified by \code{labs}. With a numeric vector,
points to be labelled are referred to by row number.}

\item{start_xy}{List containing label annotation starting coordinates.
Invoked by \code{\link[=loadlabel]{loadlabel()}}.}

\item{cex.text}{Font size for labels. Default 0.72 to match plotly font size.
See \code{\link[=text]{text()}}.}

\item{col}{Specifies which column in \code{data} affects point colour. Must be
categorical. If it is not a factor, it will be coerced to a factor.}

\item{colScheme}{A single colour or a vector of colours for points.}

\item{alpha}{Alpha value for transparency of points.}

\item{shape}{Specifies which column in \code{data} controls point shapes. If not a
factor, will be coerced to a factor.}

\item{shapeScheme}{A single symbol for points or a vector of symbols.
See \code{pch} in \code{\link[=points]{points()}}.}

\item{size}{Either a single value for size of points (default 8), or
specifies which column in \code{data} affects point size for bubble charts.}

\item{sizeRange}{Range of size of points for bubble charts.}

\item{xlab}{x axis title. Accepts expressions when exporting base graphics.
Set \code{cex.lab} to alter the font size of the axis titles (default 1).
Set \code{cex.axis} to alter the font size of the axis numbering (default 1).}

\item{ylab}{y axis title. Accepts expressions when exporting base graphics.}

\item{xlim}{The x limits (x1, x2) of the plot.}

\item{ylim}{The y limits of the plot.}

\item{xticks}{List of custom x axis ticks and labels specified as a list of
two named vectors \code{at = ...} and \code{labels = ...}. Another method is to use
\code{xaxp} as a vector of the form \code{c(x1, x2, n)} giving the coordinates of the
extreme tick marks and the number of intervals between tick-marks.}

\item{yticks}{List of custom y axis ticks and labels specified as a list of
two named vectors \code{at = ...} and \code{labels = ...}. Another method is to use
\code{yaxp} as a vector of the form \code{c(y1, y2, n)} giving the coordinates of the
extreme tick marks and the number of intervals between tick-marks.}

\item{showOutliers}{Logical whether to show outliers on the margins of the
plot.}

\item{outlier_shape}{Symbol for outliers.}

\item{outline_col}{Colour of symbol outlines. Set to \code{NA} for no outlines.}

\item{outline_lwd}{Line width of symbol outlines.}

\item{plotly_filter}{Refers to a column of logical values in \code{data} used to
filter rows to reduce the number of points shown by plotly. We recommend
using this for datasets with >100,000 rows. When saving to pdf, the full
original dataset is still plotted. This is useful for plots with millions of
points such as Manhattan plots where a subset of points to be labelled is
already known.}

\item{width}{Width of the plot in pixels. Saving to pdf scales 100 pixels to
1 inch.}

\item{height}{Height of the plot in pixels.}

\item{showgrid}{Either logical whether to show gridlines, or a character
value where "x" means showing x axis gridlines and "y" means showing y axis
gridlines.}

\item{zeroline}{Logical whether to show lines at x = 0 and y = 0.}

\item{hline}{Adds horizontal lines at values of y.}

\item{vline}{Adds vertical lines at values of x.}

\item{mgp}{The margin line for the axis title, axis labels and axis line.
See \code{\link[=par]{par()}}.}

\item{Ltitle}{A character or expression (see \link{plotmath}) value specifying
text for left side title. Size of font can be changed using \code{cex.lab}.}

\item{Rtitle}{A character or expression value specifying text for right side
title. Size of font can be changed using \code{cex.lab}.}

\item{LRtitle_side}{On which side of the plot for \code{Ltitle} and \code{Rtitle}
(1 = bottom, 3 = top). See \code{\link[=mtext]{mtext()}}.}

\item{labelDir}{Initial label line directions. Options include 'radial'
(default) for radial lines around the centre of the plot,
'origin' for radial lines around the origin,
'horiz' for horizontal and 'vert' for vertical,
'xellipse' and 'yellipse' for near-horizontal and near-vertical lines
arranged in an elliptical way around the centre,
'rect' for rectilinear lines (a mix of horizontal and vertical),
'x' for diagonal lines,
'oct' for lines in 8 directions around the centre.}

\item{labCentre}{Coordinates in x/y units of the central point towards which
radial labels converge. Defaults to the centre of the plot.}

\item{lineLength}{Initial length of label lines in pixels.}

\item{text_col}{Colour of label text. If set to
\code{"match"} label text will match the colour of each point.}

\item{line_col}{Colour of label lines. If set to
\code{"match"} label line will match the colour of each point.}

\item{rectangles}{Logical whether to show rectangles around labels
(not supported by plotly).}

\item{rect_col}{Colour for filling rectangles (not supported by plotly). If
set to \code{"match"} rectangle fill colour will match the colour of each point.}

\item{border_col}{Colour of rectangle borders (not supported by plotly).
Use \code{border_col = NA} to omit borders. If set to \code{"match"} rectangle border
colour will match the colour of each point.}

\item{padding}{Amount of padding in pixels around label text.}

\item{border_radius}{Amount of roundedness in pixels to apply to label
rectangles (not supported by plotly).}

\item{showLegend}{Logical whether to show or hide the legend.}

\item{legendxy}{Vector of coordinates for the position of the legend.
Coordinates are in plotly paper reference with \code{c(0, 0)} being the bottom
left corner and \code{c(1, 1)} being the top right corner of the plot window.
Plotly has unusual behaviour in that the x coordinate always aligns the left
side of the legend. However, the y coordinate aligns the top, middle or
bottom of the legend dependent on whether it is in the top, middle or bottom
1/3 of the plot window. So \code{c(1, 0)} positions the legend in the bottom right
corner outside the right margin of the plot, while \code{c(1, 0.5)} centre aligns
the legend around the centre of y axis.}

\item{filename}{Filename for saving plots to pdf in a browser. Rstudio opens
its own pdf file.}

\item{panel.last}{An expression to be evaluated after plotting has taken
place but before the axes, title and box are added. This can be useful for
adding extra titles, legends or trend lines. Currently only works when saving
plots using base graphics and does not work with plotly. See \link{plot.default}}

\item{fullGeneNames}{Logical whether to expand gene symbols using
Bioconductor AnnotationDbi package. With multiple matches, returns first
value only.
See \code{\link[AnnotationDbi:AnnotationDb-class]{AnnotationDbi::mapIds()}}.}

\item{AnnotationDb}{Annotation database to use when expanding gene symbols.
Defaults to human gene database \code{AnnotationDb = org.Hs.eg.db}.}

\item{custom_annotation}{List of annotations to be added via
\code{\link[plotly:layout]{plotly::layout()}}.}

\item{output_shiny}{Logical whether to output a shiny app. If \code{FALSE} a
plotly figure will be returned.}

\item{...}{Further graphical parameters passed to \code{plot()} when saving via
base graphics. The most useful for most users are likely to be \code{cex.lab}
which alters axis title font size (default 1, see \code{\link[=par]{par()}}), \code{cex.axis} which
alters axis numbering font size (default 1), and \code{panel.last} which allows
additional plotting functions to be called after the main plot has been
plotted but before the labels and label lines are drawn, which will allow the
addition of trend lines, extra titles or legends for example (see
\code{\link[=plot.default]{plot.default()}}).}
}
\value{
By default no return value. If \code{output_shiny = FALSE} or the shiny
button 'Export plotly & exit' is pressed, a plotly figure is returned.
}
\description{
Interactive labelling of scatter plots using shiny/plotly interface.
}
\details{
Instructions:
\itemize{
\item Hover over and click on/off genes which you want to label.
\item When you have selected all your chosen genes, then drag gene names to
move label positions.
\item Click the save button to export a PDF or other file types (SVG, jpeg, tiff,
png) produced in base graphics. Files are saved to the browser downloads
folder by default.
\item The Table tab shows a table view of the dataset to help with annotation.
}

The 'raster points' checkbox converts only the points to a raster which is
embedded in pdf or svg exports, while the rest of the plot (axis/label
lines/text etc) remain vectorised. This only applies when saving pdf or svg.
For other file types the whole plot is rasterized as normal by base graphics.

For efficiency, the raster of the points is cached using the \code{memoise}
package. So if users change the labels or change from pdf to svg, the export
is much faster. If the resolution is changed the points will need to be
re-rasterized.

In the shiny interface the "Save state" button saves an rds file containing
the label positions and state of the plot as an 'easylab' S3 class object to
the current working directory. This can be reloaded in future sessions using
\code{\link[=loadlabel]{loadlabel()}}.
}
\examples{

# Simple example using mtcars dataset
data(mtcars)
# Launch easylabel Shiny app: only run this example in interactive R sessions
if (interactive()) {
easylabel(mtcars, x = 'mpg', y = 'wt', col = 'cyl')
}
}
\seealso{
\code{\link[=easyVolcano]{easyVolcano()}}, \code{\link[=easyMAplot]{easyMAplot()}}, \code{\link[=easyManhattan]{easyManhattan()}}, \code{\link[=loadlabel]{loadlabel()}}
}
