% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/n_oneway.R
\name{n.oneway}
\alias{n.oneway}
\title{Calculates the required sample size for a one-way ANOVA.}
\usage{
n.oneway(iv = iv, sig.level = 0.05, power = 0.8)
}
\arguments{
\item{iv}{List of data for the treatment to be tested.}

\item{sig.level}{Desired significance level (default is 0.05).}

\item{power}{Desired level of power (default is 0.80).}
}
\value{
Returns the recommended sample size given the conditions to achieve the desired \code{power}.
}
\description{
Calculates the required sample size for a one-way ANOVA.
}
\examples{
# Exercise 8.10, p.391 from Cohen (1988)
main.eff <- list(name = "Teaching", levels = 4, eta.sq = 0.0588)
# Running the function with default settings
n.oneway(iv = main.eff)
}
\references{
Cohen, J. (1988). \emph{Statistical power analysis for the behavioral sciences} (2nd ed.). Hillsdale, N.J.: Lawrence Erlbaum Associates.
}

