% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrepl.R
\name{jrepl}
\alias{jrepl}
\title{Join and Replace Values.}
\usage{
jrepl(x, y, by, replace.cols, na.only = FALSE, only.rows = NULL,
  verbose = FALSE)
}
\arguments{
\item{x}{Main dataset which will have new values. This data set will be returned with new values.}

\item{y}{Supporting dataset which has the id and new values.}

\item{by}{Vector of join column names. A character vector if the names match. A named character vector if they don't. Passed to dplyr::inner_join.}

\item{replace.cols}{Vector of replacement column names, similar format as by.}

\item{na.only}{Only replace values that are NA.}

\item{only.rows}{Select rows to be affected. Default checks all rows.}

\item{verbose}{Print via cat information about the replacement.}
}
\value{
x with new values.
}
\description{
Replace a columns values with matches in a different dataset.
Author: Bryce Chamberlain.
}
\examples{

df1 = utils::head( sleep )
group.reassign = data.frame( 
  id.num = factor( c( 1, 3, 4 ) ), 
group.replace = factor( c( 99, 99, 99 ) ) 
)

jrepl( 
  x = df1, 
  y = group.reassign, 
  by = c( 'ID' = 'id.num' ), 
  replace.cols = c( 'group' = 'group.replace' ) 
)

# doesn't affect since there are no NAs in group.
jrepl( 
  x = df1,
  y = group.reassign, 
  by = c( 'ID' = 'id.num' ), 
  replace.cols = c( 'group' = 'group.replace' ), 
  na.only = TRUE  
) 
}
