% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache.init}
\alias{cache.init}
\title{Initialize cache.}
\usage{
cache.init(
  caches,
  at.path,
  verbose = TRUE,
  save.only = FALSE,
  skip.missing = TRUE
)
}
\arguments{
\item{caches}{List of lists with properties name, depends.on. See example.}

\item{at.path}{Where to save the cache. If NULL, a cache/ folder will be created in the current working directory.}

\item{verbose}{Print via cat() information about cache operations.}

\item{save.only}{Choose not to load the cache. Use this if you need to check cache validity in multiple spots but only want to load at the last check.}

\item{skip.missing}{Passed to hashfiles, choose if an error occurs if a depends.on file isn't found.}
}
\description{
Set cache info so easyr can manage the cache.
}
\examples{
# initialize a cache with 1 cache which depends on files in the current working directory.
# this will create a cache folder in your current working directory.
# then, you call functions to check and build the cache.
cache.init(

 # Initial file read (raw except for renaming).
 caches = list(
   list( 
    name = 'prep-files',
    depends.on = c( '.' )
   )
 ),

 at.path = tempdir()

)

}
