% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bindf-joinf.R
\name{bindf}
\alias{bindf}
\title{Bind Rows with Factors}
\usage{
bindf(..., sort.levels = TRUE)
}
\arguments{
\item{...}{data to be binded}

\item{sort.levels}{Sort the factor levels after combining them.}
}
\value{
Binded data, with any factors modified to contain all levels in the binded data.
}
\description{
Matches factor levels before binding rows. If factors have 0 levels it will change the column to character to avoid errors.
Author: Bryce Chamberlain.
}
\examples{

# create data where factors have different levels.
df1 = data.frame(
  factor1 = c( 'a', 'b', 'c' ),
  factor2 = c( 'high', 'medium', 'low' ),
  factor.join = c( '0349038u093843', '304359867893753', '3409783509735' ),
  numeric = c( 1, 2, 3 ),
  logical = c( TRUE, TRUE, TRUE )
)#' 
df2 = data.frame(
  factor1 = c( 'd', 'e', 'f' ),
  factor2 = c( 'low', 'medium', 'high' ),
  factor.join = c( '32532532536', '304359867893753', '32534745876' ),
  numeric = c( 4, 5, 6 ),
  logical = c( FALSE, FALSE, FALSE )
)

# bindf preserves factors but combines levels.
# factor-friendly functions default to ordered levels.
str( df1 )
str( bindf( df1, df2 ) )
}
