% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_dashboard.R
\name{model_dashboard}
\alias{model_dashboard}
\title{Generate a regression model summary from \code{easystats}}
\usage{
model_dashboard(
  model,
  check_model_args = NULL,
  parameters_args = NULL,
  performance_args = NULL,
  output_file = "easydashboard.html",
  output_dir = getwd(),
  rmd_dir = system.file("templates/easydashboard.Rmd", package = "easystats")
)
}
\arguments{
\item{model}{A regression model object.}

\item{check_model_args}{A list of named arguments that are passed down to
\code{performance::check_model()}. For further documentation and details
about the arguments, see \href{https://easystats.github.io/performance/reference/check_model.html}{this website}.
See also 'Examples'.}

\item{parameters_args}{A list of named arguments that are passed down to
\code{parameters::model_parameters()}. For further documentation and details
about the arguments, see \href{https://easystats.github.io/parameters/reference/model_parameters.html}{this website}.
See also 'Examples'.}

\item{performance_args}{A list of named arguments that are passed down to
\code{performance::model_performance()}. For further documentation and details
about the arguments, see \href{https://easystats.github.io/performance/reference/model_performance.html}{this website}.
See also 'Examples'.}

\item{output_file}{A string specifying the file name in \code{rmarkdown::render()}.
Default is \code{"easydashboard.html"}.}

\item{output_dir}{A string specifying the path to the output directory for
report in \code{rmarkdown::render()}. Default is to use the working directory.}

\item{rmd_dir}{A string specifying the path to the directory containing the
RMarkdown template file. By default, package uses the template shipped with
the package installation (\code{inst/templates/easydashboard.Rmd}).}
}
\value{
An HTML dashboard.
}
\description{
A dashboard containing the following details for the entered regression model:
\itemize{
\item a tabular summary of parameter estimates
\item a dot-and-whisker plot for parameter estimates
\item a tabular summary of indices for the quality of model fit
\item a collection of models for checking model assumptions
\item a text report
\item a model information table
}
}
\section{Troubleshooting}{

For models with many observations, or for more complex models in general,
generating the model assumptions plot might become very slow. One reason
is that the underlying graphic engine becomes slow for plotting many data
points. In such cases, setting the argument \code{check_model_args = list(show_dots = FALSE)}
might help. Furthermore, look at other arguments of \code{?performance::check_model},
which can be set using \code{check_model_args}, to increase performance (in
particular the \code{check}-argument can help, to skip some unnecessary checks).
}

\examples{
if (interactive()) {
  mod <- lm(wt ~ mpg, mtcars)

  # with default options
  model_dashboard(mod)

  # customizing 'parameters' output: standardize coefficients
  model_dashboard(mod, parameters_args = list(standardize = "refit"))

  # customizing 'performance' output: only show selected performance metrics
  model_dashboard(mod, performance_args = list(metrics = c("AIC", "RMSE")))

  # customizing output of model assumptions plot: don't show dots (faster plot)
  model_dashboard(mod, check_model_args = list(show_dots = FALSE))
}

}
