% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bestModels.R
\name{bestRFEAT}
\alias{bestRFEAT}
\title{Tuning a Random Forest + Efficiency Analysis Trees model}
\usage{
bestRFEAT(
  training,
  test,
  x,
  y,
  numStop = 5,
  m = 50,
  s_mtry = c("5", "BRM"),
  na.rm = TRUE
)
}
\arguments{
\item{training}{Training \code{data.frame} or \code{matrix} containing the variables for model construction.}

\item{test}{Test \code{data.frame} or \code{matrix} containing the variables for model assessment.}

\item{x}{Column input indexes in \code{training}.}

\item{y}{Column output indexes in \code{training}.}

\item{numStop}{Set of minimum number of observations in a node for a split to be attempted.}

\item{m}{Set of number of trees to be built.}

\item{s_mtry}{\code{character}. Set of options for selecting the number of inputs to be selected in each split.}

\item{na.rm}{\code{logical}. If \code{TRUE}, \code{NA} rows are omitted.}
}
\value{
\code{data.frame} in which each row corresponds to a given set of hyperparameters and the root mean squared error (RMSE).
}
\description{
This funcion computes the root mean squared error (RMSE) for a Random Forest + Efficiency Analysis Trees model built with a set of given hyperparameters.
}
\examples{
\donttest{
data("PISAindex")

n <- nrow(PISAindex) # Observations in the dataset
selected <- sample(1:n, n * 0.7) # Training indexes
training <- PISAindex[selected, ] # Training set
test <- PISAindex[- selected, ] # Test set

bestRFEAT(training = training, 
          test = test,
          x = 6:9,
          y = 3,
          numStop = c(3, 5),
          m = c(20, 30),
          s_mtry = c("1", "BRM"))
}

}
