% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemExclusionConstraint.R
\name{itemExclusionConstraint}
\alias{itemExclusionConstraint}
\title{Create item exclusion constraints.}
\usage{
itemExclusionConstraint(
  nForms,
  exclusionTuples,
  itemIDs,
  whichForms = seq_len(nForms),
  info_text = NULL
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{exclusionTuples}{\code{data.frame} with two columns, containing tuples with item IDs which should be in test forms exclusively.}

\item{itemIDs}{Character vector of item IDs in correct ordering.}

\item{whichForms}{An integer vector indicating which test forms should be constrained. Defaults to all the test forms.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Create constraints that prohibit that item pairs occur in the same test forms.
}
\details{
Item exclusion pairs can, for example, be created by the function \code{\link{itemExclusionTuples}}.
}
\examples{
## item-IDs
IDs <- c("item1", "item2", "item3", "item4")

## tuples: Item 1 can not be in the test form as item 2 and 3
exTuples <- data.frame(v1 = c("item1", "item1"), v2 = c("item2", "item3"),
                       stringsAsFactors = FALSE)

## Create constraints
itemExclusionConstraint(nForms = 2, exclusionTuples = exTuples, itemIDs = IDs)


########
## Full workflow using itemExclusionTuples
# Example data.frame
items <- data.frame(ID = c("item1", "item2", "item3", "item4"),
                     exclusions = c("item2, item3", NA, NA, NA))

# Create tuples
exTuples2 <- itemExclusionTuples(items = items, idCol = "ID", exclusions = "exclusions",
                    sepPattern = ", ")

#' ## Create constraints
itemExclusionConstraint(nForms = 2, exclusionTuples = exTuples2, itemIDs = IDs)

}
