% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objectives.R
\name{maximinObjective}
\alias{maximinObjective}
\title{Maximin Constraint.}
\usage{
maximinObjective(
  nForms,
  itemValues,
  allowedDeviation,
  weight = 1,
  whichForms = seq_len(nForms),
  info_text = NULL,
  itemIDs = names(itemValues)
)
}
\arguments{
\item{nForms}{Number of forms to be created.}

\item{itemValues}{Item parameter/values for which the sum per test form should be constrained.}

\item{allowedDeviation}{the maximum allowed deviation between the sum of the target values.}

\item{weight}{a weight for the real-valued variable(s). Useful when multiple constraints are combined. Should only be used if the implications are well understood.}

\item{whichForms}{An integer vector indicating which test forms should be constrained. Defaults to all the test forms.}

\item{info_text}{a character string of length 1, to be used in the \code{"info"}-attribute of the resulting \code{constraint}-object.}

\item{itemIDs}{a character vector of item IDs in correct ordering, or NULL.}
}
\value{
An object of class \code{"constraint"}.
}
\description{
Create \code{maximin}-constraints related to an item parameter/value. That is, the created
constraints can be used to maximize the minimal sum of the
item values (\code{itemValues}), while at the same time setting an upper limit to the
overflow by means of a maximally allowed deviation \code{allowedDeviation}.
}
\examples{
# constraint that minimizes the maximum difference per test form value and a
#   target value of 0
maximinObjective(nForms = 2, itemValues = rep(-2:2, 2),
                 allowedDeviation = 1)

}
