% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/03_DB_infos.R
\name{dbNames}
\alias{dbNames}
\title{Get variable names from a relational data base.}
\usage{
dbNames(filePath, includeMeta = FALSE)
}
\arguments{
\item{filePath}{Path of an existing \code{.db} file.}

\item{includeMeta}{Should the variable names of the \code{Meta_Data} table be included.}
}
\value{
Returns a named list of character vectors with the variables names included in the data tables.
}
\description{
Function to get the names of the variables included in the relational data base.
}
\details{
Extracts names of all variables included in the relational data base, structured as a list with the individual data tables as elements. The ordering in the list is equivalent to the merge order used when data is pulled from the data base.
}
\examples{
db_path <- system.file("extdata", "example_dataBase.db", package = "eatDB")
varNames <- dbNames(db_path)

## Names of data tables
names(varNames)

## Variable names in data table "NoImp"
varNames$NoImp

}
