% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTrendGADS.R
\name{getTrendGADS}
\alias{getTrendGADS}
\title{Get data for trend reports.}
\usage{
getTrendGADS(
  filePath1,
  filePath2,
  lePath = NULL,
  vSelect = NULL,
  years,
  fast = TRUE,
  tempPath = tempdir()
)
}
\arguments{
\item{filePath1}{Path of the first \code{eatGADS} db file.}

\item{filePath2}{Path of the second \code{eatGADS} db file.}

\item{lePath}{Path of the linking error db file. If \code{NULL}, no linking errors are added to the data.}

\item{vSelect}{Variables from both GADS to be selected (as character vector).}

\item{years}{A numeric vector of length 2. The first elements corresponds to \code{filePath1}, the second element to \code{filePath2}.}

\item{fast}{Should \code{\link{getGADS_fast}} be used for data loading instead of \code{\link{getGADS}}? Using the default is heavily recommended.}

\item{tempPath}{The directory, in which both GADS will be temporarily stored. Using the default is heavily recommended.}
}
\value{
Returns a \code{GADSdat} object.
}
\description{
Extracts variables from two \code{eatGADS} data bases and a linking error data base. Data can then be extracted from the \code{GADSdat} object via
\code{\link{extractData}}. For extracting meta data from a data base or a \code{GADSdat} object see \code{\link{extractMeta}}. To speed
up the data loading, \code{\link{getGADS_fast}} is used per default.
}
\details{
This function extracts data from two GADS data bases and a linking error data base. All data bases have to be created via
\code{\link{createGADS}}. The two GADS are joined via \code{rbind} and a variable \code{year} is added, corresponding to the
argument \code{years}. If \code{lePath} is specified, linking errors are also extracted and then merged to the GADS data. Make
sure to also extract the key variables necessary for merging the linking errors (the domain variable for all linking errors,
additionally the competence level variable for linking errors for competence levels). The \code{GADSdat} object can then further
be used via \code{\link{extractData}}. See \code{\link[eatDB]{createDB}} and \code{\link[eatDB]{dbPull}} for further explanation
of the querying and merging processes.
}
\examples{
# See getGADS vignette


}
