% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{EM}
\alias{EM}
\title{Nonparametric Maximum Likelihood via Expectation Maximization}
\usage{
EM(A, maxiter = 10000L, rtol = 1e-06)
}
\arguments{
\item{A}{numeric matrix likelihoods}

\item{maxiter}{early stopping condition}

\item{rtol}{convergence tolerance: abs(loss_new - loss_old)/abs(loss_old)}
}
\value{
the estimated prior distribution (a vector of masses corresponding
to the columns of A)
}
\description{
Compute the nonparametric maximum likelihood estimate given a likelihood
matrix. The matrix A is structured so that A_\{ij\} = f(X_i | theta_j) for
some grid of potential parameter values theta_1, ..., theta_p and
observations X_1, ..., X_n. The parameters, theta_j, can be multidimensional
because all that is required is the likelihood. Convergence is achieved when
the relative improvements of the log-likelihood is below the provided
tolerance level.
}
\examples{
set.seed(1)
t = sample(c(0,5), size = 100, replace = TRUE)
x = t + stats::rnorm(100)
gr = seq(from = min(x), to = max(x), length.out = 50)
A = stats::dnorm(outer(x, gr, "-"))
EM(A)
\dontrun{
# compare to solution from rmosek (requires additional library installation):
all.equal(
    REBayes::KWPrimal(A = A, d = rep(1, 50), w = rep(1/100, 100))$f,
    EM(A, maxiter = 1e+6, rtol = 1e-16), # EM alg converges slowly
    tolerance = 0.01
)
}
}
