% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{ebirdst_download}
\alias{ebirdst_download}
\title{Download eBird Status and Trends Data}
\usage{
ebirdst_download(
  species,
  path = rappdirs::user_data_dir("ebirdst"),
  tifs_only = TRUE,
  force = FALSE,
  show_progress = TRUE
)
}
\arguments{
\item{species}{character; a single species given as a scientific name, common
name or six-letter species code (e.g. woothr). The full list of valid
species is can be viewed in the \link{ebirdst_runs} data frame included in this
package. To download the example dataset, use "example_data".}

\item{path}{character; directory to download the data to. All downloaded
files will be placed in a sub-directory of this directory named according
to the unique run ID associated with this species. Defaults to a persistent
data directory, which can be found by calling
rappdirs::user_data_dir("ebirdst")).}

\item{tifs_only}{logical; whether to only download the GeoTIFFs for
abundance and occurrence (the default), or download the entire data
package, including data for predictor importance, partial dependence, and
predictive performance metrics.}

\item{force}{logical; if the data have already been downloaded, should a
fresh copy be downloaded anyway.}

\item{show_progress}{logical; whether to print download progress information.}
}
\value{
Path to the folder containing the downloaded data package for the
given species.
}
\description{
Download an eBird Status and Trends data package for a single species, or for
an example species, to a specified path. Accessing Status and Trends data
requires an access key, consult \code{\link[=set_ebirdst_access_key]{set_ebirdst_access_key()}} for instructions
on how to obtain and store this key. The example data consist of the results
for Yellow-bellied Sapsucker subset to Michigan and are much smaller than the
full dataset, making these data quicker to download and process. In addition,
the example data are accessible without an access key.
}
\examples{
\dontrun{
# download the example data
ebirdst_download("example_data")

# download the data package for wood thrush, geotiffs only
ebirdst_download("woothr")
# download the data package for wood thrush, all data
ebirdst_download("woothr", tifs_only = FALSE)
}
}
