% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebirdst-loading.R
\name{load_predictions}
\alias{load_predictions}
\title{Load eBird Status and Trends test data predictions}
\usage{
load_predictions(path, return_sf = FALSE)
}
\arguments{
\item{path}{character; directory that the Status and Trends data for a given
species was downloaded to. This path is returned by \code{ebirdst_download()}
or \code{get_species_path()}.}

\item{return_sf}{logical; whether to return an \link{sf} object of spatial points
rather then the default data frame.}
}
\value{
Data frame, or \link{sf} object if \code{return_sf = TRUE}, containing
observed counts and model predictiosn for the test data.
}
\description{
During eBird Status and Trends modeling, predictions are made for checklists
in a test dataset that is not included in the model fitting process. This
function loads these predictions in addition to the actual observed count on
the associated checklist. These data are used by \code{\link[=ebirdst_ppms]{ebirdst_ppms()}} to get for
calculating predictive performance metrics.
}
\examples{
\donttest{
# download example data
path <- ebirdst_download("example_data", tifs_only = FALSE)
# or get the path if you already have the data downloaded
path <- get_species_path("example_data")

# test data
test_predictions <- load_predictions(path)
dplyr::glimpse(test_predictions)
}
}
