% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ebv_map.R
\name{ebv_map}
\alias{ebv_map}
\title{Map plot of an EBV netCDF}
\usage{
ebv_map(
  filepath,
  datacubepath,
  entity = NULL,
  timestep = 1,
  countries = TRUE,
  col_rev = FALSE,
  classes = 5,
  all_data = FALSE,
  ignore_RAM = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{filepath}{Character. Path to the netCDF file.}

\item{datacubepath}{Character. Path to the datacube (use
\code{\link[=ebv_datacubepaths]{ebv_datacubepaths()}}).}

\item{entity}{Character or Integer. Default is NULL. If the structure is 3D,
the entity argument is set to NULL. Else, a character string or single
integer value must indicate the entity of the 4D structure of the EBV
netCDFs.}

\item{timestep}{Integer. Choose one timestep.}

\item{countries}{Logical. Default: TRUE. Simple country outlines will be
plotted on top of the raster data. Disable by setting this option to FALSE.}

\item{col_rev}{Logical. Default: FALSE Set to TRUE if you want the color ramp
to be the other way around.}

\item{classes}{Integer. Default: 5. Define the amount of classes (quantiles)
for the symbology. Currently restricted to maximum 11 classes (allowed
maximum for palette RdYlBu is 11).}

\item{all_data}{Logical. Default: FALSE. The quantiles are based on the one
timestep you chose (default). If you want include the full data of the
datacube to produce several maps that are based on the same color scale,
set this argument to TRUE (to allow for viusual comparison between entities
or timesteps. Does not cover different datacubes.)}

\item{ignore_RAM}{Logical. Default: FALSE. Checks if there is enough space in
your memory to read the data. Can be switched off (set to TRUE).}

\item{verbose}{Logical. Default: TRUE. Turn off additional prints by setting
it to FALSE.}
}
\value{
Plots a map.
}
\description{
Map plot of the data of one timestep in one datacube of an EBV
netCDF.
}
\examples{
\donttest{
#set path to EBV netCDF
file <- system.file(file.path("extdata","martins_comcom_subset.nc"), package="ebvcube")
#get all datacubepaths of EBV netCDF
datacubes <- ebv_datacubepaths(file, verbose=FALSE)

#plot a map for the 3rd timestep, divide into 7 classes
ebv_map(filepath = file, datacubepath = datacubes[1,1], entity = 1,
        timestep = 3, classes = 7)
}
}
